<?php
/*
 * @package Subscribe Feed
 * @author Nando Pappalardo
 * @version 1.0.
 */
/*
Plugin Name: subscribe-feed
Plugin URI: http://www.yourinspirationweb.com/2009/06/23/come-creare-un-widget-in-wordpress-28/
Description: Questo widget ti permette di aggiungere la sottoscrizione ai feed del tuo blog.
Author: Nando Pappalardo
Version: 1.0
Author URI: http://www.yourinspirationweb.com
*/


/* Aggiungi la funzione al gancio widgets_init */
add_action( 'widgets_init', 'my_widget_subscribe_feed' );

/* Funzione che registra il widget */
function my_widget_subscribe_feed() {
	register_widget( 'Subscribe_Feed' );
}

class Subscribe_Feed extends WP_Widget {

    function Subscribe_Feed() {
		/* Impostazione del widget */
		$widget_ops = array( 'classname' => 'subscribe-feed', 'description' => 'Questo widget ti permette di aggiungere la sottoscrizione ai feed del tuo blog.' );

		/* Impostazioni di controllo del widget */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'subscribe-feed' );

		/* Creiamo il widget */
		$this->WP_Widget( 'subscribe-feed', 'Subscribe Feed', $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );

		/* User-selected settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$FeedBurner = $instance['FeedBurner'];
		$show_subscribe_by_feedBurner = isset( $instance['show_subscribe_by_feedBurner']) ? $instance['show_subscribe_by_feedBurner'] : false;
		$FeedCount = $instance['FeedCount'];
		$show_FeedCount = isset( $instance['show_FeedCount'] ) ? $instance['show_FeedCount'] : false;

		/* Before widget (definito dal tema). */
		echo $before_widget;

		/* Titolo del widget (before e after definiti dal tema). */
		if ( $title )
			echo $before_title . $title . $after_title;

		/* Visualizza l'iscrizione ai Feed tramite FeedBurner */
		if ( $show_subscribe_by_feedBurner )
			echo '<a href="'.$FeedBurner.'" title="iscriviti ai feed">iscriviti ai feed rss</a><br/>';

		/* Visualizza il Contatore degli iscritti ai Feed */
		if ( $show_FeedCount )
			echo $FeedCount;

		/* After widget (definito dal tema). */
		echo $after_widget;
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags (se necessario) e modifica la configurazione del widget. */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['show_subscribe_by_feedBurner'] = $new_instance['show_subscribe_by_feedBurner'];
		$instance['FeedBurner'] = $new_instance['FeedBurner'];
		$instance['FeedCount'] = $new_instance['FeedCount'];
		$instance['show_FeedCount'] = $new_instance['show_FeedCount'];

		return $instance;
	}
	
	function form( $instance ) {

		/* Impostazioni di default del widget */
		$defaults = array( 'title' => 'Iscriviti ai Feed', 'show_subscribe_by_feedBurner' => '', 'show_subscribe_by_feedBurner' => false, 'FeedCount' => '', 'show_FeedCount' => true );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" style="width:100%;" />
		</p>
		
		<!-- sottoscrizione al feed dei post tramite feedburner -->
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $instance['show_subscribe_by_feedBurner'], true ); ?> id="<?php echo $this->get_field_id( 'show_subscribe_by_feedBurner' ); ?>" name="<?php echo $this->get_field_name( 'show_subscribe_by_feedBurner' ); ?>" />
			<label for="<?php echo $this->get_field_id( 'show_subscribe_by_feedBurner' ); ?>">Visualizzare Iscrizione tramite FeedBurner?</label>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'FeedBurner' ); ?>">Url FeedBurner:</label>
			<input id="<?php echo $this->get_field_id( 'FeedBurner' ); ?>" name="<?php echo $this->get_field_name( 'FeedBurner' ); ?>" value="<?php echo $instance['FeedBurner']; ?>" style="width:100%;" />
		</p>
		
		<!-- display feed count -->
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $instance['show_FeedCount'], true ); ?> id="<?php echo $this->get_field_id( 'show_FeedCount' ); ?>" name="<?php echo $this->get_field_name( 'show_FeedCount' ); ?>" />
			<label for="<?php echo $this->get_field_id( 'show_FeedCount' ); ?>">Visualizzare FeedCount?</label>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'FeedCount' ); ?>">Codice FeedCount :</label>
                <textarea name="<?php echo $this->get_field_name( 'FeedCount' ); ?>" rows="6" cols="50" id="<?php echo $this->get_field_id( 'FeedCount' ); ?>" class="large-text code"><?php echo $instance['FeedCount']; ?></textarea>
            </label>
		</p>

		<?php
	}
}
?>