<?php
/*
Plugin Name: Follow Us
Plugin URI: http://www.yourinspirationweb.com/2009/11/10/plugin-wordpress-follow-us-i-social-network-sulla-sidebar/
Description: This widget allows you to add the subscription to the various social network for your blog.
Author: Nando Pappalardo
Version: 1.0.
Author URI: http://www.yourinspirationweb.com

USAGE:

	LICENCE:

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
       
*/

/*
 * Determine the location
 */
$follow_us_plugin_path = WP_CONTENT_URL.'/plugins/'.plugin_basename(dirname(__FILE__)).'/';

function follow_us_css() {
	global $follow_us_plugin_path;
	wp_enqueue_style('follow-us-css',$follow_us_plugin_path.'follow-us.css');
}
add_action('wp_print_styles', 'follow_us_css');

load_plugin_textdomain('follow-us','wp-content/plugins/follow-us/language/');

/* Aggiungiamo la nostra funzione al gancio widgets_init */
add_action( 'widgets_init', 'my_widget_follow_us' );

/* Funzione che registra il nostro widget */
function my_widget_follow_us() {
	register_widget( 'Follow_us' );
}

class Follow_us extends WP_Widget {

    function Follow_us() {
		/* Impostazione del widget */
		$widget_ops = array( 'classname' => 'widget_follow-us', 'description' => __('This widget allows you to add the subscription to the various social network for your blog.','follow-us') );

		/* Impostazioni di controllo del widget */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'widget_follow-us' );

		/* Creiamo il widget */
		$this->WP_Widget( 'widget_follow-us', __('Follow Us','follow-us'), $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );

		/* User-selected settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		
		$show_subscribe_on_facebook   = isset( $instance['show_subscribe_on_facebook']) ? $instance['show_subscribe_on_facebook'] : false;
		$url_Facebook                 = $instance['url_Facebook'];
		$text_Facebook                = $instance['text_Facebook'];
		
		$show_follow_on_twitter       = isset( $instance['show_follow_on_twitter']) ? $instance['show_follow_on_twitter'] : false;
		$url_Twitter                  = $instance['url_Twitter'];
		$text_Twitter                 = $instance['text_Twitter'];
		
		$show_subscribe_rss           = isset( $instance['show_subscribe_rss']) ? $instance['show_subscribe_rss'] : false;
		$url_Feed                     = $instance['url_Feed'];
		$text_Feed                    = $instance['text_Feed'];
		
		$show_subscribe_newsletter    = isset( $instance['show_subscribe_newsletter']) ? $instance['show_subscribe_newsletter'] : false;
		$url_newsletter               = $instance['url_newsletter'];
		$text_newsletter              = $instance['text_newsletter'];
		
		$show_subscribe_delicious     = isset( $instance['show_subscribe_delicious']) ? $instance['show_subscribe_delicious'] : false;
		$url_delicious                = $instance['url_delicious'];
		$text_delicious               = $instance['text_delicious'];

		/* Before widget (definito dal tema). */
		echo $before_widget;

		/* Titolo del widget (before e after definiti dal tema). */
		if ( $title )
			echo $before_title . $title . $after_title;

		echo "<ul>";
		
		/* Visualizza diventa fan su facebook */
		if ( $show_subscribe_on_facebook )
			echo '<li class="facebook"><a href="'.$url_Facebook.'" title="">'.$text_Facebook.'</a></li>';
			
		/* Visualizza seguici su twitter */
		if ( $show_follow_on_twitter )
			echo '<li class="twitter"><a href="'.$url_Twitter.'" title="">'.$text_Twitter.'</a></li>';
			
		/* Visualizza l'iscrizione ai Feed */
		if ( $show_subscribe_rss )
			echo '<li class="rss"><a href="'.$url_Feed.'" title="">'.$text_Feed.'</a></li>';
			
		/* Visualizza l'iscrizione alla Newsletter */
		if ( $show_subscribe_newsletter )
			echo '<li class="newsletter"><a href="'.$url_newsletter.'" title="">'.$text_newsletter.'</a></li>';
			
		/* Visualizza l'iscrizione a Delicious */
		if ( $show_subscribe_delicious )
			echo '<li class="delicious"><a href="'.$url_delicious.'" title="">'.$text_delicious.'</a></li>';
			
		echo "</ul>";

		/* After widget (definito dal tema). */
		echo $after_widget;
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags (if needed) and update the widget settings. */
		$instance['title'] = strip_tags( $new_instance['title'] );
		
		$instance['show_subscribe_on_facebook'] = $new_instance['show_subscribe_on_facebook'];
		$instance['url_Facebook'] = $new_instance['url_Facebook'];
		$instance['text_Facebook'] = $new_instance['text_Facebook'];
		
		$instance['show_follow_on_twitter'] = $new_instance['show_follow_on_twitter'];
		$instance['url_Twitter'] = $new_instance['url_Twitter'];
		$instance['text_Twitter'] = $new_instance['text_Twitter'];
		
		$instance['show_subscribe_rss'] = $new_instance['show_subscribe_rss'];
		$instance['url_Feed'] = $new_instance['url_Feed'];
		$instance['text_Feed'] = $new_instance['text_Feed'];
		
		$instance['show_subscribe_newsletter'] = $new_instance['show_subscribe_newsletter'];
		$instance['url_newsletter'] = $new_instance['url_newsletter'];
		$instance['text_newsletter'] = $new_instance['text_newsletter'];
		
		$instance['show_subscribe_delicious'] = $new_instance['show_subscribe_delicious'];
		$instance['url_delicious'] = $new_instance['url_delicious'];
		$instance['text_delicious'] = $new_instance['text_delicious'];		

		return $instance;
	}
	
	function form( $instance ) {

		/* Impostazioni di default del nostro widget */
		$defaults = array( 'title' => __('Follow us','follow-us'), 'show_subscribe_on_facebook' => false, 'url_Facebook' => '', 'text_Facebook' => __('My Blog on <span>Facebook</span>','follow-us'), 
		                   'show_follow_on_twitter' => false, 'url_Twitter' => '', 'text_Twitter' => __('My Blog on <span>Twitter</span>','follow-us'), 
		                   'show_subscribe_rss' => false, 'url_Feed' => '', 'text_Feed' => __('Subscribe My Blog <span>Feed</span>','follow-us'),
		                   'show_subscribe_newsletter' => false, 'url_newsletter' => '', 'text_newsletter' => __('Subscribe <span>Newsletter</span>','follow-us'), 
		                   'show_subscribe_delicious' => false, 'url_delicious' => '', 'text_delicious' => __('My Blog on <span>Delicious</span>','follow-us') );
		                   
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:','follow-us') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" style="width:100%;" />
		</p>
		
		<!-- diventa fan su facebook -->
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $instance['show_subscribe_on_facebook'], true ); ?> id="<?php echo $this->get_field_id( 'show_subscribe_on_facebook' ); ?>" name="<?php echo $this->get_field_name( 'show_subscribe_on_facebook' ); ?>" />
			<label for="<?php echo $this->get_field_id( 'show_subscribe_on_facebook' ); ?>"><?php _e('Display the Facebook account?','follow-us') ?></label>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'url_Facebook' ); ?>"><?php _e('Facebook URL:','follow-us') ?></label>
			<input id="<?php echo $this->get_field_id( 'url_Facebook' ); ?>" name="<?php echo $this->get_field_name( 'url_Facebook' ); ?>" value="<?php echo $instance['url_Facebook']; ?>" style="width:100%;" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'text_Facebook' ); ?>"><?php _e('Text to link:','follow-us') ?></label>
			<input id="<?php echo $this->get_field_id( 'text_Facebook' ); ?>" name="<?php echo $this->get_field_name( 'text_Facebook' ); ?>" value="<?php echo $instance['text_Facebook']; ?>" style="width:100%;" />
		</p>
		
		<!-- seguici su twitter -->
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $instance['show_follow_on_twitter'], true ); ?> id="<?php echo $this->get_field_id( 'show_follow_on_twitter' ); ?>" name="<?php echo $this->get_field_name( 'show_follow_on_twitter' ); ?>" />
			<label for="<?php echo $this->get_field_id( 'show_follow_on_twitter' ); ?>"><?php _e('Display follow us on Twitter?','follow-us') ?></label>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'url_Twitter' ); ?>"><?php _e('Twitter URL:','follow-us') ?></label>
			<input id="<?php echo $this->get_field_id( 'url_Twitter' ); ?>" name="<?php echo $this->get_field_name( 'url_Twitter' ); ?>" value="<?php echo $instance['url_Twitter']; ?>" style="width:100%;" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'text_Twitter' ); ?>"><?php _e('Text to link:','follow-us') ?></label>
			<input id="<?php echo $this->get_field_id( 'text_Twitter' ); ?>" name="<?php echo $this->get_field_name( 'text_Twitter' ); ?>" value="<?php echo $instance['text_Twitter']; ?>" style="width:100%;" />
		</p>
		
		<!-- sottoscrizione ai feed -->
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $instance['show_subscribe_rss'], true ); ?> id="<?php echo $this->get_field_id( 'show_subscribe_rss' ); ?>" name="<?php echo $this->get_field_name( 'show_subscribe_rss' ); ?>" />
			<label for="<?php echo $this->get_field_id( 'show_subscribe_rss' ); ?>"><?php _e('Display subscription to Feed?','follow-us') ?></label>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'url_Feed' ); ?>"><?php _e('Feed URL:','follow-us') ?></label>
			<input id="<?php echo $this->get_field_id( 'url_Feed' ); ?>" name="<?php echo $this->get_field_name( 'url_Feed' ); ?>" value="<?php echo $instance['url_Feed']; ?>" style="width:100%;" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'text_Feed' ); ?>"><?php _e('Text to link:','follow-us') ?></label>
			<input id="<?php echo $this->get_field_id( 'text_Feed' ); ?>" name="<?php echo $this->get_field_name( 'text_Feed' ); ?>" value="<?php echo $instance['text_Feed']; ?>" style="width:100%;" />
		</p>
		
		<!-- sottoscrizione alla newsletter -->
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $instance['show_subscribe_newsletter'], true ); ?> id="<?php echo $this->get_field_id( 'show_subscribe_newsletter' ); ?>" name="<?php echo $this->get_field_name( 'show_subscribe_newsletter' ); ?>" />
			<label for="<?php echo $this->get_field_id( 'show_subscribe_newsletter' ); ?>"><?php _e('Display the newsletter subscription?','follow-us') ?></label>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'url_newsletter' ); ?>"><?php _e('Newsletter URL:','follow-us') ?></label>
			<input id="<?php echo $this->get_field_id( 'url_newsletter' ); ?>" name="<?php echo $this->get_field_name( 'url_newsletter' ); ?>" value="<?php echo $instance['url_newsletter']; ?>" style="width:100%;" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'text_newsletter' ); ?>"><?php _e('Text to link:','follow-us') ?></label>
			<input id="<?php echo $this->get_field_id( 'text_newsletter' ); ?>" name="<?php echo $this->get_field_name( 'text_newsletter' ); ?>" value="<?php echo $instance['text_newsletter']; ?>" style="width:100%;" />
		</p>
		
		<!-- sottoscrizione a delicious -->
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $instance['show_subscribe_delicious'], true ); ?> id="<?php echo $this->get_field_id( 'show_subscribe_delicious' ); ?>" name="<?php echo $this->get_field_name( 'show_subscribe_delicious' ); ?>" />
			<label for="<?php echo $this->get_field_id( 'show_subscribe_delicious' ); ?>"><?php _e('Display the account on delicious?','follow-us') ?></label>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'url_delicious' ); ?>"><?php _e('Delicious URL:','follow-us') ?></label>
			<input id="<?php echo $this->get_field_id( 'url_delicious' ); ?>" name="<?php echo $this->get_field_name( 'url_delicious' ); ?>" value="<?php echo $instance['url_delicious']; ?>" style="width:100%;" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'text_delicious' ); ?>"><?php _e('Text to link:','follow-us') ?></label>
			<input id="<?php echo $this->get_field_id( 'text_delicious' ); ?>" name="<?php echo $this->get_field_name( 'text_delicious' ); ?>" value="<?php echo $instance['text_delicious']; ?>" style="width:100%;" />
		</p>

		<?php
		
	}
}
?>