jQuery(document).ready(function($){
	
	//Elemento aggiuntivo per contenere messaggi d'errore
	$("<div>")
	.attr("class","error")
	.prependTo("body")
	.hide();
	
	//Regole di validazione      
	$("#formYIW").validate({
		rules: {
			nome: {
				required:true,
				minlength:2
			},
			cognome: {
				required: true,
				minlength:2
			},
			email: {
				required: true,
				email: true
			},
			username: {
				required: true,
				minlength: 2,
				maxlength: 20
			},
			password: {
				required: true
			},
			passwordrpt: {
				required: true,
				equalTo: "#password"
			}
		},//rules
		
		//Messaggi d'errore
    messages:{
    	nome: {
    		required: "Devi inserire un nome",
    		minlength: "Il nome deve essere minimo 2 caratteri"
    	},
    	cognome: {
    		required: "Devi inserire un cognome",
    		minlength: "Il nome deve essere minimo 2 caratteri"
    	},
    	email: {
    		required: "Devi inserire l'email",
    		email: "Inserisci una email valida"
    	},
    	username: {
    		required: "Devi inserire l'username",
    		minlength: "Username minimo 2 caratteri",
    		maxlength: "Username massimo 20 caratteri"
    	},
    	password: {
    		required: "Devi inserire una password"
    	},
    	passwordrpt: {
    		required: "Le password devono coincidere",
    		equalTo: "Le password devono coincidere"
    	}
    },//messages
        
		//azioni da intraprendere in caso di errore
		highlight: function(element, errorClass){
			$(element).parent("li").addClass(errorClass);
		},
		//e quando l'errore viene risolto
		unhighlight: function(element, errorClass){
			$(element).parent("li").removeClass(errorClass);
		},
		//funzione eseguita in caso di errore:
		//mostra/nasconde il box di informazioni con il 
		//conteggio degli errori
		invalidHandler: function(e, validator) {
			var errors = validator.numberOfInvalids();
			var message = '';
			if (errors) {
				if(errors == 1)
					message = 'Un campo è incompleto: per favore riempilo.';
				else
					message = 'Per favore, correggi i ' + errors + ' campi contrassegnati in rosso.';
				$("div.error").html(message);
				$("div.error").show();
			} else {
				$("div.error").hide();
			}
		},//invalidHandler
		submitHandler: function() { alert("Form inviato!!") }
	});//validate
});
