<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
    <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
    <title><?php bloginfo('name'); ?></title>
    <link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
	<link rel="alternate" type="application/rss+xml" title="<?php printf(__('%s RSS Feed', 'yiw'), get_bloginfo('name')); ?>" href="<?php bloginfo('rss2_url'); ?>" />
    <link rel="alternate" type="application/atom+xml" title="<?php printf(__('%s Atom Feed', 'yiw'), get_bloginfo('name')); ?>" href="<?php bloginfo('atom_url'); ?>" />
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	<?php wp_head(); ?>
</head>

<body>
	<!-- START CONTAINER -->
	<div class="container">
		<!-- START HEADER -->
		<h1>
			<a href="<?php echo get_option('home'); ?>/" title="Ritorna alla Home Page">
				<?php bloginfo('name'); ?>
			</a>
		</h1>
		
		<p class="center"><?php bloginfo('description'); ?></p>
		
		<!-- START NAVIGATION -->
		<?php wp_page_menu('menu_class=nav&show_home=1'); ?>
		<!-- END NAVIGATION -->
		
		<!-- END HEADER -->
		
		<!-- START COLONNA SINISTRA -->
		<div id="content">
			<?php if (have_posts()) : ?>
				
				<!-- START LOOP -->
				<?php while (have_posts()) : the_post(); ?>

					<!-- BEGIN POST -->
					<div <?php post_class(); ?>>
						
                        <!-- START TITLE POST -->
						<h2>
							<a href="<?php the_permalink() ?>">
								<?php the_title(); ?>
							</a>
						</h2>
						<!-- END TITLE POST -->
						
						<!-- START DATE -->
						<p class="data">
							<?php the_time('j F Y') ?> di <?php the_author() ?>
						</p>
						<!-- END DATE -->
						
						<!-- START POST CONTENT -->
						<div class="entry">
							<?php the_content(__('|| continua a leggere &raquo;')); ?>
						</div>
						<!-- END POST CONTENT -->
						
						<!-- START CATEGORY POST -->
						<p class="postmetadata">
							Pubblicato in <?php the_category(', ') ?>
						</p>
						<!-- END CATEGORY POST -->
						
						<!-- START COMMENTS -->
						<p class="right">
							<?php comments_popup_link('Nessun commento &raquo;', '1 Commento &raquo;', '% Commenti &raquo;'); ?>
						</p>
						<!-- END COMMENTS -->
						
					</div>
					<!-- END POST -->
					
				<?php endwhile; ?>
				<!-- END LOOP -->
				
				<!-- START NAVIGATION -->
				<div class="navigation">
					<div class="alignleft"><?php next_posts_link(__('&laquo; Precedenti')) ?></div>
					<div class="alignright"><?php previous_posts_link(__('Successivi &raquo;')) ?></div>
				</div>
				<!-- END NAVIGATION -->

			<?php else: ?>
				<h2><?php _e('Non trovato'); ?></h2>
				<p class="center"><?php _e('Siamo spiacenti, quello che stavi cercando non  su questa pagina'); ?></p> 	
			<?php endif; ?>
    
		</div>
		<!-- END COLONNA SINISTRA -->
	</div>
	<!-- END CONTAINER -->
</body>

</html>