<?php
/*
Template Name: Contatti
*/
?>

<?php get_header(); ?>
		
		<!-- START COLONNA SINISTRA -->
		<div id="content">
			<?php if (have_posts()) : ?>
				
				<!-- START LOOP -->
				<?php while (have_posts()) : the_post(); ?>

					<!-- BEGIN POST -->
					<div <?php post_class(); ?>>
						
						<!-- START TITLE -->
						<h2>
							<a href="<?php the_permalink() ?>">
								<?php the_title(); ?>
							</a>
						</h2>
						<!-- END TITLE -->
						
						<!-- START POST CONTENT -->
						<div class="entry">
							<?php the_content(__('|| continua a leggere &raquo;')); ?>
						</div>
						<!-- END POST CONTENT -->
						
						<!-- START COMMENTS -->
						<p class="right">
							<?php comments_popup_link('Nessun commento &raquo;', '1 Commento &raquo;', '% Commenti &raquo;'); ?>
						</p>
						<!-- END COMMENTS -->
						
					</div>
					<!-- END POST -->
					
				<?php endwhile; ?>
				<!-- END LOOP -->
				
				<!-- START MODULO CONTATTI -->
				<form id="contacts" method="post" action="">
					<fieldset>
						<legend>Modulo contatti</legend>
						<label for="visitor">Nome:</label>
						<input tabindex="1" type="text" id="visitor" name="visitor" value="" /><br/>
						
						<label for="visitortel">Tel:</label>
						<input tabindex="2" type="text" id="visitortel" name="visitortel" value="" /><br/>
						
						<label for="visitormail">E-mail:</label>
						<input tabindex="3" type="text" id="visitormail" name="visitormail" value="" /><br/>
						
						<label for="notes">Messaggio:</label>
						<textarea tabindex="4" id="notes" name="notes" cols="30" rows="3"><?php echo $notes?></textarea><br/>

						<input tabindex="5" type="submit" id="invia" name="invia" value="invia" />
					</fieldset>
				</form>
				<!-- END MODULO CONTATTI -->
				
				<!-- START NAVIGATION -->
				<div class="navigation">
					<div class="alignleft"><?php next_posts_link(__('&laquo; Precedenti')) ?></div>
					<div class="alignright"><?php previous_posts_link(__('Successivi &raquo;')) ?></div>
				</div>
				<!-- END NAVIGATION -->

			<?php else: ?>
				<h2><?php _e('Non trovato'); ?></h2>
				<p class="center"><?php _e('Siamo spiacenti, quello che stavi cercando non  su questa pagina'); ?></p> 	
			<?php endif; ?>
    
		</div>
		<!-- END COLONNA SINISTRA -->
		
		<!-- START SIDEBAR -->
		<?php get_sidebar(); ?>
		<!-- END SIDEBAR -->
		
		<div class="clearer"></div>
		
		<!-- START FOOTER -->
		<div class="footer">
			<p>Copyright 2010 &copy; Your Inspiration WordPress</p>
		</div>
		<!-- END FOOTER -->
		
	</div>
	<!-- END CONTAINER -->
	
</body>

</html>