<div id="comments">
	<?php if ( post_password_required() ) : ?>
				<p class="nopassword"><?php _e( 'Questo articolo  protetto da password. Inserisci la password per visualizzare i commenti.', 'yiw' ); ?></p>
			</div><!-- #comments -->
	<?php
		return;
	endif;
?>

<?php if ( have_comments() ) : ?>
			<h3 id="comments-title">
                <?php comments_number(__('nessun commento', 'yiw'), __('1 commento', 'yiw'), __('% commenti', 'yiw')); ?>
			</h3>

			<ol class="commentlist">
				<?php
					wp_list_comments( array( 'type' => 'comment' ) );
				?>
			</ol>

<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
			<div class="navigation">
				<div class="nav-previous"><?php previous_comments_link( __( '<span class="meta-nav">&larr;</span> Commenti precedenti', 'yiw' ) ); ?></div>
				<div class="nav-next"><?php next_comments_link( __( 'Commenti successivi <span class="meta-nav">&rarr;</span>', 'yiw' ) ); ?></div>
			</div><!-- .navigation -->
<?php endif; ?>
	

<?php else : // o, se non ci sono commenti

		/* Se non ci sono commenti e i commenti sono chiusi */
		if ( ! comments_open() ) :
?>
			<p class="nocomments"><?php _e( 'I commenti sono chiusi.', 'yiw' ); ?></p>
	<?php endif; // end ! comments_open() ?>

<?php endif; // end have_comments() ?>

<?php if ( comments_open() ) : // se i commenti sono permessi aggiungiamo il modulo che permette di commentare ?>

	<div id="respond">
	
		<!-- START TITLE LEAVE A REPLY -->
		<h2 id="leave-reply">Lascia un commento</h2>
		<!-- END TITLE LEAVE A REPLY -->
        
		<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
			<!-- START MESSAGE REQUEST REGISTRATION COMMENTS -->
			<p><?php printf(__('Devi eseguire il <a href="%s">login</a> per inserire un commento.', 'yiw'), get_option('siteurl') . '/wp-login.php?redirect_to=' . urlencode(get_permalink())); ?></p>
			<!-- END MESSAGE REQUEST REGISTRATION COMMENTS -->
		<?php else : ?>
		
		<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
		
			<?php if ( $user_ID ) : ?>
				<p><?php printf(__('Sei loggato come <a href="%1$s">%2$s</a>.', 'yiw'), get_option('siteurl') . '/wp-admin/profile.php', $user_identity); ?> <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="<?php _e('Log out da questo account', 'yiw'); ?>"><?php _e('Log out &raquo;', 'yiw'); ?></a></p>
			<?php endif; ?>
		
			<textarea name="comment" id="comment" cols="100%" rows="10" tabindex="1"></textarea>
			
			<?php if ( !$user_ID ) : ?>
				<p>
					<label for="author">Nome <?php if ($req) _e(" (richiesto)", 'yiw'); ?></label>
				</p>
				
				<p>
					<input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" tabindex="2" />
				</p>

				<p>
					<label for="email">Mail <?php if ($req) _e(" (richiesto)", 'yiw'); ?></label>
				</p>
				
				<p>
					<input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" tabindex="3" />
				</p>

				<p>
					<label for="url">Website</label>
				</p>
				
				<p>
					<input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" tabindex="4" />
				</p>
			<?php endif; ?>
		
			<p>
				<input name="submit" type="submit" id="submit" tabindex="5" value="Invia Commento" />
				<?php comment_id_fields(); ?>
			</p>
			<?php do_action('comment_form', $post->ID); ?>
		</form>
		<?php endif; ?>
	</div><!-- #respond -->
			
<?php endif; ?>

</div><!-- #comments -->
