<?php
# *************** - BEGIN LICENSE BLOCK - ***********************************
#
# itDate class
#
# Copyright (C) 2010 Maurizio Tarchini <info@mtxweb.ch>  
#
#
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# *************** - END LICENSE BLOCK - **************************************
class itDate
{
	protected static function isWin()
	{
		$sys = strtoupper(PHP_OS);
   
   		if(substr($sys,0,3) == "WIN")
   		{
       		return TRUE;
   		}
   		return FALSE;
	}
	
	protected static function set_locale()
	{
		$localString = "it_IT";
		
		if(self::isWin())
		{
			$localString = "ita_ITA";
		}
		
		setlocale(LC_TIME,$localString);
	}
	
	public static function _getItDate($format, $timestamp = FALSE)
	{
		self::set_locale();
		
		if(!$timestamp)
		{
			$timestamp = time();
		}
		
		$date = strftime($format,$timestamp);
		$date = str_replace('', '&igrave;', $date);
		return $date;
	}
}

//L'utilizzo  molto semplice
//Basta passare il formato richiesto come argomento
//in questo modo restituisce la data attuale

echo itDate::_getItDate("%A %d %B");

//Passando come argomento anche il timestamp
//Restituisce la data relativa a quel timestamp

echo itDate::_getItDate("%A %d %B", 1468803225);
?>