<?php

#################### - BEGIN LICENSE BLOCK - ################################
#																			#
# mobileDetect class														#
#																			#
# Copyright (C) Maurizio Tarchini - Your Inspiration Web  					#
#																			#
#																			#
#																			#
# This program is free software: you can redistribute it and/or modify		#
# it under the terms of the GNU General Public License as published by		#
# the Free Software Foundation, either version 3 of the License, or			#
# (at your option) any later version.										#
#																			#
# This program is distributed in the hope that it will be useful,			#
# but WITHOUT ANY WARRANTY; without even the implied warranty of			#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the				#
# GNU General Public License for more details.								#
#																			#
# You should have received a copy of the GNU General Public License			#
# along with this program.  If not, see http://www.gnu.org/licenses/		#
#																			#
#################### - END LICENSE BLOCK - ##################################



/**
 * mobileDetect
 *
 * @package none
 * @author Tarchini Maurizio
 * @metaAuthor YIW
 * @copyright 2011
 * @version 1.0.0 - beta 1
 * @access public
 */
class mobileDetect
{
	/**
	* Name of mobile device
	* 
	* @since 1.0.0
	* @var string
	*/
	public $mobileName;
	
	/**
	* Is mobile device
	*
	* @since 1.0.0
	* @var bool
	*/
	public $isMobile;
	
	/** 
	* Is touchscreen device
	*
	* @since 1.0.0
	* @var bool
	*/
	public $isTouch;
	
	/**
	* The object containing the data on devices
	*
	* @since 1.0.0
	* @var object
	*/
	private $xmlContent;
	
	
	  /**
	   * mobileDetect::__construct()
	   *
	   * class constructor
	   * This method initializes the properties 
	   * and methods of the class, loads 
	   * data from xml file and create object xmlContent
	   */
		public function __construct($device_list_url='http://the-devices-detection.googlecode.com/svn/last/device-list.xml')
		{
			$this->isMobile = FALSE;
			$this->mobileName = FALSE;
			$this->isTouch = FALSE;
			
			$list = file_get_contents($device_list_url);
			$this->xmlContent = simplexml_load_string($list);
			$this->_mobile();
		}
		
	  /**
	   * mobileDetect::_mobile()
	   *
	   * This method enhances the isMobile property to "TRUE" 
	   * if the request is from a mobile device and isTouch to "TRUE"
	   * if the mobile device has a touch screen. 
	   * The property mobileName is valued  with the device name
	   * @since 1.0.0
	   * @return void
	   */
		private function _mobile()
		{
			
			foreach($this->xmlContent->device as $item)
			{	
				if(stripos($_SERVER['HTTP_USER_AGENT'], trim($item->name)))
				{
					$this->isMobile = TRUE;
					$this->mobileName = trim($item->name);
					if($item->touch == 1)
					{
						$this->isTouch = TRUE;
					}
					break;
				}
			}
			return;
		}
		
		/**
		*mobileDetect::mobileDetectInfo()
		*
		* This method displays information about the list of devices
		* @since 1.0.0
		* @return void
		*/
		public function mobileDetectInfo()
		{
			echo '<h1>About mobileDetect</h1>';
			echo 'Version: ' . $this->xmlContent->about->version . '<br />';
			echo 'Date: ' . $this->xmlContent->about->date . '<br />';
			echo 'License: ' . $this->xmlContent->about->license . '<br />';
			echo 'Author: <a href="mailto:' . $this->xmlContent->about->author->email . '">' . $this->xmlContent->about->author->name . '</a><br />';
			
			if(count($this->xmlContent->about->credits->credit))
			{
				echo '<br /><strong>Credits</strong><br />';
				
				foreach($this->xmlContent->about->credits->credit as $credit)
				{
					echo $credit . '<br />';	
				}
				echo '<br />';
			}
			
			echo 'Supported devices: ' . count($this->xmlContent->device);
			echo '<br /><br />List of supported device:<br />';
			echo '<ul>
			';
			foreach($this->xmlContent->device as $item)
			{
				echo '<li>' . $item->name;
				
				if($item->touch == 1)
				{
					echo ' (touch)';
				}
				echo '</li>';
			}
			echo '</ul>';
			
			return;
		}
		
}

/**
mobileDetect.class usually takes the file from the repository with the latest data. 
This is the default configuration and is recommended.
You can still use (and modify) the file device-list.xml.
In this case you need to give the url of the file device-list.xml as argument.

$mobileDetect = new mobileDetect(http://www.your-site.com/path-to-file);
*/
$mobileDetect = new mobileDetect();
?>