<?php 
/**
 * Document: file.php
 * Created on: 13-dic-2011, 10:57
 * Author : Nicola Mustone <mustone.nicola@gmail.com>
   		    per Your Inspiration Web [http://www.yourinspirationweb.com]
 * Description: Classe YCFile. Mette a disposizione dei metodi per la gestione dei file.
 */
class YCFile {
	/**
	 * YCFile::exists(). Controlla che il file esista.
	 *
	 * @static
	 * @param string $file
	 * @param bool $getInfo
	 * @return bool|array
	 */
	public static function exists($file, $getInfo = FALSE) {
		if(is_file($file)) {
			if($getInfo) { return pathinfo($file); }
			return true;
		}
		
		return false;
	}
	
	/**
	 * YCFile::isReadable(). Controlla che il file sia leggibile.
	 *
	 * @static
	 * @param string $file
	 * @return bool
	 */
	public static function isReadable($file) {
		return (self::exists($file) AND is_readable($file));
	}
	
	/**
	 * YCFile::ext(). Restituisce l'estensione del file.
	 *
	 * @static
	 * @param string $file
	 * @return string
	 */
	public static function ext($file) {
		return substr($file, strrpos($file, '.') + 1);
	}
	
	/**
	 * YCFile::name(). Restituisce il nome del file senza estensione o path.
	 *
	 * @static
	 * @param string $file
	 * @return string
	 */
	public static function name($file) {
		if(DIRECTORY_SEPARATOR != '/') {
			$file = str_replace(DIRECTORY_SEPARATOR, '/', $file);
		}
		
		$lastSlash = strrpos($file, '/');
		
		if($lastSlash) {
			$file = substr($file, $lastSlash + 1);
		}
		
		return substr($file, 0, strrpos($file, '.'));
	}
	
	/**
	 * YCFile::realName(). Restituisce il nome del file comprensivo di estensione.
	 *
	 * @static
	 * @param string $file
	 * @return string
	 */
	public static function realName($file) {
		return self::name($file) . '.' . self::ext($file);	
	}
	
	/**
	 * YCFile::sanitizeName(). Elimina caratteri non consentiti dal nome del file.
	 *
	 * @static
	 * @param string $file
	 * @return string
	 */
	public static function sanitizeName($file) {
		$fileName = preg_replace('/[^\w\.\-]/', '_', self::realName($file));
		return dirname($file) . DIRECTORY_SEPARATOR . $fileName;
	}
	
	/**
	 * YCFile::find(). Cerca un file.
	 *
	 * @static
	 * @param string $file
	 * @param string $base
	 * @return string
	 */
	public static function find($file, $base) {	}
	
	/**
	 * YCFile::listFile(). Genera un array contenente i file trovati nella cartella indicata.
	 *
	 * @param string $dir
	 * @param string $ext
	 * @return bool|array
	 */
	public static function listFile($dir, $ext = false) { }
	
	/**
	 * YCFile::delete(). Cancella un file.
	 *
	 * @static
	 * @param string $file
	 * @return stirng
	 */
	public static function delete($file) { }
	
	/**
	 * YCFile::read(). Legge il contenuto di un file.
	 *
	 * @static
	 * @param string $file
	 * @param int $totalChunk
	 * @param int $chunkSize
	 * @param int $offset
	 * @return mixed
	 */
	public static function read($file, $totalChunk = 0, $chunkSize = 8192, $offset = 0) { }
	
	/**
	 * YCFile::download(). Prepara gli header per il download e permette di scaricare il file.
	 *
	 * @static
	 * @param string $file
	 * @return bool Se fallisce la lettura.
	 */
	public static function download($file) { }
}
?>