<?php
/*
 * Initialize the widget
 */
add_action('widgets_init', 'FPG_registerWidget');

/*
 * Callback function for add_action
 */
function FPG_registerWidget(){
    register_widget('FPG_widget');
}
/*
 * Extends the WP_widget class to create the widget for this plugin
 */
class FPG_widget extends WP_widget{
    /*
     * This is the "constructor" function, it enqueues jquery and a custom function js
     * for the widget, and the style for it, include also the phpFlickr class.
     * 
     * Sets the basic options for the widget to be shown in the admin panel and sets
     * the widget controls settings, then initialize the widget
     */
    public function FPG_widget(){
        //widget setting
        add_action('admin_print_styles',array($this,'widgetEnqueueAdminStuff'));
        add_action('init',array($this,'widgetEnqueueStuff'));
        include_once('phpFlickr/phpFlickr.php');
        $widget_ops = array('classname'=>'fpg_widget', 
            'description' => 'This widget shows the last <em>n</em> photos from a Flickr account');
        //widget-control settings
        $control_ops = array('width'=> 500, 'height'=> 350, 'id_base'=>'fpg_widget');
        $this->WP_Widget('fpg_widget', 'FlickrPhotogallery Widget', $widget_ops, $control_ops);
    }
    /*
     * enqueue scripts in frontend
     */
    public function widgetEnqueueStuff()
    {
        wp_enqueue_script('jquery');
        wp_enqueue_script('FPG_widgetFunction', WP_PLUGIN_URL.'/FlickrPhotogallery/script/widgetFunction.js');
        wp_enqueue_style('FPG_WidgetStyle', WP_PLUGIN_URL .'/FlickrPhotogallery/css/widgetStyle.css');

    }
    public function widgetEnqueueAdminStuff()
    {
                    //enqueue color picker
        wp_enqueue_style( 'farbtastic' );
        wp_enqueue_script( 'farbtastic' );    
    }
    /*
     * Prints the form in the widget admin page
     * 
     * The javacript below the form is for adding some effects, such as field hiding
     * @param $instace 
     */
    public function form($instance){
        $type = "public";
        $userId = "";
        $photosetId = "";
        $numOfImages = 5;
        $title = "";
        $showAs = "list";
        $width = "240";
        $borderColor = '#cccccc';
        $useFancybox = false;
        $defaults = array('title'=>$title,
                          'type'=>$type,
                          'userId'=>$userId,
                          'photosetId'=>$photosetId,
                          'numOfImages'=>$numOfImages,
                          'showAs' => $showAs,
                          'width' => $width,
                          'borderColor' => $borderColor,
                          'useFancybox' => $useFancybox);
        $instance = wp_parse_args((array)$instance, $defaults);  ?>
<table class="form-table">
    <tbody>
        <tr valign="top">
            <th scope="row">
                <label for="<?php echo $this->get_field_id('title');?>">Title:</label>              
            </th>
            <td>
                <input id="<?php echo $this->get_field_id('title');?>" name="<?php echo $this->get_field_name('title');?>" value="<?php echo $instance['title'];?>" style="width:100%" /> 
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="<?php echo $this->get_field_id('type');?>">Type of Pool:</label>                
            </th>
            <td>
                <select id="<?php echo $this->get_field_id('type');?>" name="<?php echo $this->get_field_name('type');?>">
                    <option value="public" <?php selected($instance['type'], "public"); ?>>Public</option>
                    <option value="user" <?php selected($instance['type'], "user"); ?>>User</option>
                    <option value="photoset" <?php selected($instance['type'], "photoset"); ?>>Photoset</option>
                    <option value="group" <?php selected($instance['type'], "group");?>>Group</option>
                </select>
                <span class="description">You can show public images or from a specifiy user, photoset or group</span>               
            </td>
        </tr>
        <tr valign="top" id="<?php echo $this->id;?>idRow">
            <th scope="row">
                <label for="<?php echo $this->get_field_id('userId');?>" id="<?php echo $this->id;?>idLabel">Your Flickr User Id:</label>   
            </th>
            <td>
                <input type="text" name="<?php echo $this->get_field_name('userId');?>" id="<?php echo $this->get_field_id('userId');?>" value="<?php echo $instance['userId']; ?>" />
                <span class="description"><a href="#" id="<?php echo $this->id;?>findMyIdWidget">Find your FlickrId</a></span>
            </td>
        </tr>
        <tr valign="top" id="<?php echo $this->id;?>photosetRow">
            <th scope="row">
                <label for="<?php echo $this->get_field_id('photosetId');?>">Your Photoset Id:</label>
            </th>
            <td>
                <input type="text" name="<?php echo $this->get_field_name('photosetId');?>" id="<?php echo $this->get_field_id('photosetId');?>" value="<?php echo $instance['photosetId']; ?>" />    
                <span class="description">Insert the Id of your Photoset here</span>    
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="<?php echo $this->get_field_id('numOfImages');?>">Number of Images to Show:</label>    
            </th>
            <td>
                <input type="text" name="<?php echo $this->get_field_name('numOfImages');?>" id="<?php echo $this->get_field_id('numOfImages');?>" value="<?php echo $instance['numOfImages']; ?>" />
                <span class="description">Insert the number of images you want to show</span>               
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="<?php echo $this->get_field_id('showAs');?>">Show images as:</label>
            </th>
            <td>
                <select id="<?php echo $this->get_field_id('showAs');?>" name="<?php echo $this->get_field_name('showAs');?>">
                    <option value="list" <?php selected($instance['showAs'], 'list');?>>List</option>
                    <option value="slideshow" <?php selected($instance['showAs'], 'slideshow');?>>Slideshow</option>
                </select>
            </td>
        </tr>
        <tr valign="top" id="<?php echo $this->id; ?>widthRow">
            <th scope="row">
                <label for="<?php echo $this->get_field_id('width'); ?>">Slideshow Width:</label>
            </th>
            <td>
                <input type="text" name="<?php echo $this->get_field_name('width');?>" id="<?php echo $this->get_field_id('width');?>" value="<?php echo $instance['width'];?>" />
            </td>
        </tr>
<tr valign="top">
  <th scope="row">
    <label for="<?php echo $this->get_field_id('borderColor');?>">Border color</label>
  </th>
  <td>
    <input type="text" id="<?php echo $this->get_field_id('borderColor');?>" name="<?php echo $this->get_field_name('borderColor');?>" value="<?php echo $instance['borderColor']; ?>" />
    <div id="<?php echo $this->id;?>-ilctabscolorpicker"></div>
  </td>
</tr>        
        <tr valign="top">
           <th scope="row">
               <label for="<?php echo $this->get_field_id('useFancybox');?>">Use fancybox</label> 
           </th>
           <td>
               <input type="checkbox" name="<?php echo $this->get_field_name('useFancybox');?>" id="<?php echo $this->get_field_id('useFancybox');?>" value="true" <?php checked($instance['useFancybox'], "true");?>/>
           </td>
       </tr>
    </tbody>
</table>
<script type="text/javascript">
jQuery(document).ready(function($){
    $('#<?php echo $this->id;?>-ilctabscolorpicker').hide();
    $('#<?php echo $this->id;?>-ilctabscolorpicker').farbtastic("#<?php echo $this->get_field_id('borderColor');?>");
    $("#<?php echo $this->get_field_id('borderColor');?>").click(function(){$('#<?php echo $this->id;?>-ilctabscolorpicker').slideToggle()});
    function showIdSettingsOnChange()
    {
        $('#<?php echo $this->id;?>idRow, #<?php echo $this->id;?>photosetRow').hide();
        //declare control variable
        var checkType = $('#<?php echo $this->get_field_id('type');?>').val();
        //if the select value is user or group
        //show the id settings
        if(checkType.match(/(user|group)/))
        {
            $('#<?php echo $this->id;?>idRow').show();
            $('#<?php echo $this->id;?>idLabel').text(checkType == 'user' ? "Your Flickr User Id:" : "Your Flickr Group Id:");
        }
        else if(checkType == 'photoset')
        {
            $('#<?php echo $this->id;?>idRow').show();
            $('#<?php echo $this->id;?>idLabel').text("Your Flickr User Id:");
            $('#<?php echo $this->id;?>photosetRow').show();
        }
    };
    
    function showSlideshowWidth()
    {
        $('#<?php echo $this->id;?>widthRow').hide();
        var checkShowAs = $('#<?php echo $this->get_field_id('showAs');?>').val();
        if(checkShowAs =='slideshow')
        {
            $('#<?php echo $this->id;?>widthRow').show();
        }
    }
    showSlideshowWidth();
    showIdSettingsOnChange();    
    $('#<?php echo $this->get_field_id('showAs');?>').change(showSlideshowWidth);
    $('#<?php echo $this->get_field_id('type');?>').change(showIdSettingsOnChange);

                    
                    
    $('#<?php echo $this->id;?>findMyIdWidget').click(function(){
       //declare a control variable
       var checkType = $('#<?php echo $this->get_field_id('type');?>').val();
       //prompt for flickr url for user or group
       //depending on what the user choose
       var x = prompt(checkType.match(/(user|photoset)/) ? 'Enter the URL of your flickr account' : 'Enter the URL of your flickr group', 
                      checkType.match(/(user|photoset)/) ? 'http://flickr.com/photos/your_username/' : 'http://flickr.com/groups/your_group/');
       if(!x) return false;
       var url = "http://api.flickr.com/services/rest/?"+
                "method="+(checkType.match(/(user|photoset)/) ? "flickr.urls.lookupUser&" : "flickr.urls.lookupGroup&")+
                "api_key=353077acfc6e1a37787fedb753efeaba&"+
                "format=json&"+
                "jsoncallback=?&"+
                "url="+x;
       $.getJSON(url, function(result){
           if (result.stat != 'ok')
           {
               alert('Problems occurred retrieving your id, please try again');
               return false
           }
           $('#<?php echo $this->get_field_id('userId');?>').val(checkType.match(/(user|photoset)/) ? result.user.id : result.group.id);
       });
    });
})
</script>
        <?php
        
    }
    /*
     * Update the options for the widget
     * 
     * @param array @new_instance The options to set after updating
     * @param array @old_instance The options to be updated 
     * 
     * @return array
     */
    public function update($new_instance, $old_instance){
        $instance = $old_instance;
        
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['type'] = $new_instance['type'];
        $instance['userId'] = $new_instance['userId'];
        $instance['photosetId'] = $new_instance['photosetId'];
        $instance['numOfImages'] = $new_instance['numOfImages'];
        $instance['showAs'] = $new_instance['showAs'];
        $instance['width'] = $new_instance['width'];
        $instance['borderColor'] = $new_instance['borderColor'];
        $instance['useFancybox'] = $new_instance['useFancybox'];
        return $instance;
    }
    /*
     * Prints the widget
     * For first extract the argouments and set some variables, then check which
     * type of pool is selected by the user and set an array containing the images.
     * Prints the $before_widget element
     * Prints the widget, changing the classes due to the user selection (slideshow or list)
     * Prints the $after_widget element
     */
    public function widget($args, $instance){
        extract($args);
        $title = apply_filters('widget_title',$instance['title']);
        //create a new instance of phpFlickr class
        //!!!DO NOT MODIFY/DELETE THE ARGUMENT!!!
        $FPG_widget = new phpFlickr('353077acfc6e1a37787fedb753efeaba');
        $title = $instance['title'];
        $type = $instance['type'];
        $userId = $instance['userId'];
        $photosetId = $instance['photosetId'];
        $numOfImages = $instance['numOfImages'];
        $showAs = $instance['showAs'];
        $borderColor = $instance['borderColor'];
        $width = $instance['width'];
        switch ($width)
        {
            case ($width<=75):
                $imageDim = 'square';
                break;
            case (($width > 75) && ($width <= 100)):
                $imageDim = 'thumbnail';
                break;
            case (($width > 100) && ($width <= 240)):
                $imageDim = 'small';
                break;
            case (($width > 240) && ($width <= 500)):
                $imageDim = 'medium';
                break;
            case (($width > 500) && ($width <= 640)):
                $imageDim = 'medium_640';
                break;
            case ($width > 640):
                $imageDim = 'large';
                break;
            default:
                $imageDim = 'small';                
        } 
        //$useFancybox = $instance['useFancybox'];
        if($instance['useFancybox'])
        {
            $useFancybox = $instance['useFancybox'];
        }else{$useFancybox = false;}
         switch($type)
         {
             case ('public'):
                 //set the array that contains the images
                 $images = $FPG_widget->photos_getRecent(NULL, NULL, $numOfImages, 1);
                 break;
             case ('user'):
                 $images = $FPG_widget->people_getPublicPhotos($userId, NULL, NULL, $numOfImages);
                 break;
             case('photoset'):
                 $images = $FPG_widget->photosets_getPhotos($photosetId, NULL, NULL, $numOfImages);
                 break;
             case ('group'):
                 $images = $FPG_widget->groups_pools_getPhotos($userId, NULL, NULL, NULL, NULL, $numOfImages);
                 break;
         }
        echo $before_widget;
        //print the container div
        ?>
        <h3 class="FPG_widgetTitle"><?php echo $instance['title']; ?></h3>
        <div class="FPG_widgetContainer<?php echo $showAs=='list'?'List':'Slide'; ?>">
        <?php 
        /*
         * If the type of view is "slideshow" add some css rules
         */
        if($showAs == 'slideshow')
        {
            ?> 
            <style type="text/css">
                div.FPG_widgetContainerSlide{
                    max-width:<?php echo $width; ?>px;
                    max-height:<?php echo floor(($width/3)*2); ?>px;
                    border-color: <?php echo $borderColor; ?> !important;
                }
                div.FPG_widgetContainerSlide ul.FPG_slideUl{
                    height:<?php echo $width; ?>px;
                }
                div.FPG_widgetContainerSlide ul.FPG_slideUl li.FPG_widgetImageContainerSlide{
                    width:<?php echo $width; ?>px;
                }
                div.FPG_widgetContainerSlide ul.FPG_slideUl li.FPG_widgetImageContainerSlide a img{
                    min-width:<?php echo $width; ?>px;
                }
            </style>  
            <?php
        } else{
        ?> 
            <style>
                li.FPG_widgetImageContainerList{ border-color: <?php echo $borderColor; ?> !important; }
            </style>
        <?php } ?>
            <ul class="<?php echo $showAs=='list'?'FPG_listUl':'FPG_slideUl'; ?>">
        <?php
            if(array_key_exists('photoset',$images))
            {
                $images['photos'] = $images['photoset'];
                unset($images['photoset']);
            } 
            foreach ((array)$images['photos']['photo'] as $image){
                ?>
                <li class="FPG_widgetImageContainer<?php echo $showAs=='list'?'List':'Slide'; ?>">
                    <a title="<?php echo $image['title'];?>" 
                <?php
                if($useFancybox){
                ?>
                        rel="FPG_flickrFancybox-<?php echo $this->id;?>" class="FPG_fancybox"
                        href="<?php echo $FPG_widget->buildPhotoURL($image, 'medium_640');?>">
                <?php
                } else{
                ?>
                   href="http://www.flickr.com/photos/<?php echo $image['owner'];?>/<?php echo $image['id'];?>"> 
                <?php
                } ?>
                    <img src="<?php echo $FPG_widget->buildPhotoURL($image, ($showAs == 'list'?'square':$imageDim));?>" alt="<?php echo $image['title'];?>" />
                </a>
                </li>
                <?php
            }
        echo $after_widget;
    }
}
?>
