<?php
/*
 * Plugin Name: FlickrPhotogallery
 * Plugin URI: http://thetibashole.tumblr.com
 * Description: A plugin to show the last photos from Flickr
 * Version: 1.0
 * Author: Tiziano Basile
 * Author URI: http://thetibashole.tumblr.com
 */

/*
 * Include the widget
 */
include_once('fpg_widget.php');

/*
 * This plugin is written in OOP, so every time you need to declare a callback
 * function, it must be declared as an array element, where the first parameter
 * is the context ($this) and the second is the function itself.
 */
class FlickrPhotogallery
{
    public $FPG_shortcodeId = 0;
    /*
     * Enqueue styles and javascript when the plugin is called.
     * It includes the style for the elements printed by it, the fancybox one and
     * include also jQuery and two of its plugins: jQuery-fancybox and jQuery-easing.
     * It also includes the phpFlickr class, to get interfaced with FlickrAPI
     * 
     * Adds the admin page and register some options when the plugin is installed
     * for the first time
     */
    public function __construct()
    { 
        //include scripts
        add_action('wp_enqueue_scripts', array($this,'FPG_enqueueStuff'));
        include_once('phpFlickr/phpFlickr.php');
        // Set activation hook for the plugin
        register_activation_hook(__FILE__, array($this,"FPG_setDefaultOptionsOnInstallation"));
        //initialize option group in admin backend
        add_action('admin_init',array($this,'FPG_registerOptionGroup'));
        //add an option page for the plugin
        add_action('admin_menu',array($this,'FPG_addOptionPage'));
        //add a shortcode for the plugin
        add_shortcode('FlickrPhotogallery', array($this,'FPG_shortcode'));
        //add shortcode button(s) to TinyMCE
        add_action('init', array($this,'FPG_addTinyMCEButtons'));
    }
    /*
     * This function enqueue scripts and stylesheets
     */
    public function FPG_enqueueStuff()
    {
        wp_enqueue_script('jquery');
        wp_enqueue_style('FPG_style', WP_PLUGIN_URL . '/FlickrPhotogallery/css/FPG_style.css');
        wp_enqueue_style('FPG_fancyboxStyle', WP_PLUGIN_URL . '/FlickrPhotogallery/script/fancybox/jquery.fancybox-1.3.4.css');
        wp_enqueue_script('FPG_function', WP_PLUGIN_URL. '/FlickrPhotogallery/script/FPG_function.js', array('jquery'));
        wp_enqueue_script('FPG_fancybox', WP_PLUGIN_URL. '/FlickrPhotogallery/script/fancybox/jquery.fancybox-1.3.4.pack.js', array('jquery'));
        wp_enqueue_script('FPG_facybox_easing', WP_PLUGIN_URL. '/FlickrPhotogallery/script/fancybox/jquery.easing-1.3.pack.js', array('jquery')); 
    }
    /*
     * Initialization function for TinyMCE buttons
     */
    public function FPG_addTinyMCEButtons()
    {
        if(!current_user_can('edit_posts') && !current_user_can('edit_pages')) {return;}
        if (get_user_option('rich_editing') == 'true')
        {
            add_filter('mce_external_plugins', array($this,'FPG_addPlugin'));
            add_filter('mce_buttons', array($this,'FPG_registerButtons'));
        }
    }
    /*
     * register shortcode button for TinyMCE
     */
    public function FPG_registerButtons($buttons)
    {
        array_push($buttons, "|", "FlickrPhotogallery", "FlickrPhotogalleryWithParameters");
        return $buttons;
    }
    /*
     * register TinyMCE plugin
     */
    public function FPG_addPlugin($plugin_array)
    {
        $plugin_array['FlickrPhotogallery'] = WP_PLUGIN_URL . '/FlickrPhotogallery/script/FPG_mcebutton.js';
        return $plugin_array;
    }
    /*
     * Shortcode handler
     * it lets you to insert last photos wherever you want in your post
     */
    public function FPG_shortcode($atts, $content = null)
    {
        //increment a variable to identify each shortcode used
        //in order to assign it a different class-identifier
        $this->FPG_shortcodeId;
        $this->FPG_shortcodeId ++;
        $atts = shortcode_atts(array(
            "type" => get_option('FPG_type'),
            "userid" => get_option('FPG_flickrId'),
            "photosetid" => get_option('FPG_photosetId'),
            "numofimages" => get_option('FPG_numOfImages'),
            "intext" => get_option('FPG_inText'),
            "showas" => get_option('FPG_showAs'),
            "width" => (get_option('FPG_showAs') == 'list')? 150 : get_option('FPG_width'),
            "bordercolor" => get_option('FPG_borderColor'),
            "usefancybox" => get_option('FPG_useFancybox')), $atts);
        switch ($atts['width'])
        {
            case ($atts['width']<=75):
                $imageDim = 'square';
                break;
            case (($atts['width'] > 75) && ($atts['width'] <= 100)):
                $imageDim = 'thumbnail';
                break;
            case (($atts['width'] > 100) && ($atts['width'] <= 240)):
                $imageDim = 'small';
                break;
            case (($atts['width'] > 240) && ($atts['width'] <= 500)):
                $imageDim = 'medium';
                break;
            case (($atts['width'] > 500) && ($atts['width'] <= 640)):
                $imageDim = 'medium_640';
                break;
            case ($atts['width'] > 640):
                $imageDim = 'large';
                break;
            default:
                $imageDim = 'small';                
        }         
        if($atts['showas'] == 'list'){
            $classSwitcher = 'List';
        }
        else{$classSwitcher = 'Slide';}
        $f = new phpFlickr('353077acfc6e1a37787fedb753efeaba');
        switch($atts['type'])
        {
             case ('public'):
                 //set the array that contains the images
                 $images = $f->photos_getRecent(NULL, NULL, $atts['numofimages'], 1);
                 break;
             case ('user'):
                 $images = $f->people_getPublicPhotos($atts['userid'], NULL, NULL, $atts['numofimages']);
                 break;
             case('photoset'):
                 $images = $f->photosets_getPhotos($atts['photosetid'], NULL, NULL, $atts['numofimages']);
                 break;
             case ('group'):
                 $images = $f->groups_pools_getPhotos($atts['userid'], NULL, NULL, NULL, NULL, $atts['numofimages']);
                 break;                 
        } 
        ob_start();
        ?>
        <h3 class="FPG_title"><?php echo $atts['intext'];?></h3>
        <div class="FPG_flickrContainer<?php echo $classSwitcher; ?>">
        <?php 
        /*
         * If the type of view is "slideshow" add some css rules
         */
        if($atts['showas'] == 'slideshow')
        {
            ?> 
            <style type="text/css">
                div.FPG_flickrContainerSlide{
                    max-width:<?php echo $atts['width']; ?>px;
                    max-height:<?php echo floor(($atts['width']/3)*2); ?>px;
                    border-color: <?php echo $atts['bordercolor']; ?>;
                }
                div.FPG_flickrContainerSlide ul.FPG_ulSlide{
                    height:<?php echo $atts['width']; ?>px;
                }
                div.FPG_flickrContainerSlide ul.FPG_ulSlide li.FPG_imageContainerSlide{
                    width:<?php echo $atts['width']; ?>px;
                }
                div.FPG_flickrContainerSlide ul.FPG_ulSlide li.FPG_imageContainerSlide a img{
                    min-width:<?php echo $atts['width']; ?>px;
                }
            </style>  
            <?php
        } else{ ?>
            <style>
                li.FPG_imageContainerList{ border-color: <?php echo $atts['bordercolor']; ?> !important; }
            </style>
        <?php } ?>
        <ul class="FPG_ul<?php echo $classSwitcher;?>">
        <?php
        if(array_key_exists('photoset',$images))
        {
            $images['photos'] = $images['photoset'];
            unset($images['photoset']);
        }
        foreach ((array)$images['photos']['photo'] as $image)
         { 
        ?>
            <li class="FPG_imageContainer<?php echo $classSwitcher;?>">
                <a title="<?php echo $image['title'];?>" 
                <?php
                if($atts['usefancybox']){
                ?>
                        rel="FPG_flickrFancybox-<?php echo $this->FPG_shortcodeId;?>" class="FPG_fancybox"
                        href="<?php echo $f->buildPhotoURL($image, 'medium_640');?>">
                <?php
                } else{
                ?>
                   href="http://www.flickr.com/photos/<?php echo $image['owner'];?>/<?php echo $image['id'];?>"> 
                <?php
                } ?>
                    <img src="<?php echo $f->buildPhotoURL($image, $imageDim); ?>" />
                </a>
                <span class="FPG_descriptionContainer"><?php echo $image['title'];?></span>
            </li>
         <?php } ?>
        </ul></div>
        <?php
        $fpg_shortcodeReturns = ob_get_clean();
        return $fpg_shortcodeReturns;  
    }
     /*
      * Set the default options at the first installation of the plugin
      * You can change the first value to assing at these options as you wish
      */
     function FPG_setDefaultOptionsOnInstallation()
     {
         add_option("FPG_type", "public");
         add_option("FPG_flickrId", '' );
         add_option("FPG_photosetId", '');
         add_option("FPG_numOfImages", 3);
         add_option("FPG_inText", "Please take a look to my last photos on Flickr:");
         add_option("FPG_showAs", "list");
         add_option("FPG_useFancybox", "false");
         add_option("FPG_width", 240);
         add_option("FPG_borderColor","#cccccc");
     }
     /*
      * Register options as an unique set of options
      */
     function FPG_registerOptionGroup()
     {
         register_setting("FPG_optionsGroup", "FPG_type");
         register_setting("FPG_optionsGroup", "FPG_flickrId");
         register_setting("FPG_optionsGroup", "FPG_photosetId");
         register_setting("FPG_optionsGroup", "FPG_numOfImages");
         register_setting("FPG_optionsGroup", "FPG_inText");
         register_setting("FPG_optionsGroup", "FPG_showAs");
         register_setting("FPG_optionsGroup", "FPG_useFancybox");
         register_setting("FPG_optionsGroup", "FPG_width");
         register_setting("FPG_optionsGroup", "FPG_borderColor");
     }
     /*
      * Prints the admin form for the plugin
      * 
      * In this form you can customize the plugin selecting the type of pool,
      * the number of images to show, the user Id (or group Id) and the photoset Id
      * 
      * In the Javascript below the form there are some effects (such as the hide
      * of some fields) and a little form validation. There is also a code that
      * automatically retrieve the user Id (or group Id) from a flickr account url.
      */
     function FPG_configurationForm()
     {
         ?>
        <div class="wrap">
            <div class="icon32" id="icon-options-general"><br /></div>
            <h2>FlickrPhotogallery Configuration Page</h2>
            <p>Here you can set the default values for the plugin in order to use the shortcode without any attribute</p>
            <form method="post" action="options.php" id="FPG_optionForm">
                <?php settings_fields('FPG_optionsGroup'); ?>
                <table class="form-table">
                    <tbody>
                        <tr valign="top">
                            <th scope="row">
                                <label for="fpg_type">Select a type of Pool:</label>
                            </th>
                            <td>
                                <select id="fpg_type" name="FPG_type">
                                    <option value="public" <?php selected(get_option('FPG_type'), "public"); ?>>Public</option>
                                    <option value="user" <?php selected(get_option('FPG_type'), "user"); ?>>User</option>
                                    <option value="photoset" <?php selected(get_option('FPG_type'), "photoset"); ?>>Photoset</option>
                                    <option value="group" <?php selected(get_option('FPG_type'), "group"); ?>>Group</option>
                                </select>
                                <span class="description">You can choose to show public images or related to a specifiy user, photoset or group</span>
                            </td>
                        </tr>
                        <tr valign="top" id="idRow">
                            <th scope="row">
                                <label for="fpg_flickrId" id="idLabel">Your Flickr User Id:</label>
                            </th>
                            <td>
                                <input type="text" name="FPG_flickrId" id="fpg_flickrId" value="<?php echo get_option('FPG_flickrId'); ?>" />
                                <span class="description">Insert your Flickr Id here <a href="#" id="findMyId">Find your FlickrId</a></span>
                            </td>
                        </tr>
                        <tr valign="top" id="photosetRow">
                            <th scope="row">
                                <label for="fpg_photosetId">Your Photoset Id:</label>
                            </th>
                            <td>
                                <input type="text" name="FPG_photosetId" id="fpg_photosetId" value="<?php echo get_option('FPG_photosetId'); ?>" />
                                <span class="description">Insert the Id of your Photoset here</span>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="fpg_numOfImages">Number of Images to Show:</label>
                            </th>
                            <td>
                                <input type="text" name="FPG_numOfImages" id="fpg_numOfImages" value="<?php echo get_option('FPG_numOfImages'); ?>" />
                                <span class="description">Insert the number of images you want to show</span>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="fpg_inText">Introduction text:</label>
                            </th>
                            <td>
                                <textarea id="fpg_inText" name="FPG_inText" style="width:400px; height:200px;"><?php echo get_option('FPG_inText'); ?></textarea>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="fpg_showAs">Show photos as:</label>
                            </th>
                            <td>
                                <select id="fpg_showAs" name="FPG_showAs">
                                    <option value="list" <?php selected(get_option('FPG_showAs'), "list"); ?>>List-items</option>
                                    <option value="slideshow" <?php selected(get_option('FPG_showAs'), "slideshow"); ?>>Slideshow</option>
                                </select>
                                <span class="description">Select how you want to show your photos</span>
                            </td>
                        </tr>
                        <tr valign="top" id="widthRow">
                            <th scope="row">
                                <label for="fpg_width">Slideshow Width:</label>
                            </th>
                            <td>
                                <input type="text" name="FPG_width" id="fpg_width" value="<?php echo get_option('FPG_width');?>" />
                            </td>
                        </tr>
                        <tr valign="top">
                          <th scope="row">
                            <label for="fpg_borderColor">Border color</label>
                          </th>
                          <td>
                            <input type="text" id="fpg_borderColor" name="FPG_borderColor" value="<?php echo get_option('FPG_borderColor'); ?>" />
                            <div id="fpg_colorPicker"></div>
                          </td>
                        </tr>
                        <tr valign="top">
                           <th scope="row">
                               <label for="fpg_useFancybox">Use fancybox</label> 
                           </th>
                           <td>
                               <input type="checkbox" name="FPG_useFancybox" id="fpg_useFancybox" value="true" <?php checked(get_option('FPG_useFancybox'), "true");?>/>
                               <span class="description">Select to use Fancybox effects or to redirect to Flickr when the user clicks on a photo</span>
                           </td>
                       </tr>
                        <tr valign="top">
                           <th scope="row"></th>
                               <td>
                                   <p>
                                       <input type="submit" class="button-primary" id="submit" name="submit" value="<?php _e('Save Changes') ?>" />
                                   </p>
                               </td>
                       </tr>
                    </tbody>
                </table>
            </form>
           <script type="text/javascript">
              jQuery(document).ready(function($){
                $('#fpg_colorPicker').hide();
                $('#fpg_colorPicker').farbtastic("#fpg_borderColor");
                $("#fpg_borderColor").click(function(){$('#fpg_colorPicker').slideToggle()});
                    function showIdSettingsOnChange()
                    {
                        $('#idRow, #photosetRow').hide();
                        //declare control variable
                        var checkType = $('#fpg_type').val();
                        //if the select value is user or group
                        //show the id settings
                        if(checkType.match(/(user|group)/))
                        {
                            $('#idRow').show();
                            $('#idLabel').text(checkType == 'user' ? "Your Flickr User Id:" : "Your Flickr Group Id:");
                        }
                        else if(checkType == 'photoset')
                        {
                            $('#idRow').show();
                            $('#idLabel').text("Your Flickr User Id:");
                            $('#photosetRow').show();
                        }
                    };
                    function showSlideshowWidth()
                    {
                        $('#widthRow').hide();
                        var checkShowAs = $('#fpg_showAs').val();
                        if(checkShowAs =='slideshow')
                        {
                            $('#widthRow').show();
                        }
                    }
                    showSlideshowWidth();
                    $('#fpg_showAs').change(showSlideshowWidth);
                    $('#fpg_type').change(showIdSettingsOnChange);
                    showIdSettingsOnChange();
                    $('#findMyId').click(function(){
                       //declare a control variable
                       var checkType = $('#fpg_type').val();
                       //prompt for flickr url for user or group
                       //depending on what the user choose
                       var x = prompt(checkType.match(/(user|photoset)/) ? 'Enter the URL of your flickr account' : 'Enter the URL of your flickr group', 
                                      checkType.match(/(user|photoset)/) ? 'http://flickr.com/photos/your_username/' : 'http://flickr.com/groups/your_group/');
                       if(!x) return false;
                       var url = "http://api.flickr.com/services/rest/?"+
                                "method="+(checkType.match(/(user|photoset)/) ? "flickr.urls.lookupUser&" : "flickr.urls.lookupGroup&")+
                                "api_key=353077acfc6e1a37787fedb753efeaba&"+
                                "format=json&"+
                                "jsoncallback=?&"+
                                "url="+x;
                       $.getJSON(url, function(result){
                           if (result.stat != 'ok')
                           {
                               alert('Problems occurred retrieving your id, please try again');
                               return false
                           }
                           $('#fpg_flickrId').val(checkType.match(/(user|photoset)/) ? result.user.id : result.group.id);
                       });
                    });
                });
            </script>
         <?php
     }    
     /*
      * Add the option page in wordpress administration
      * Used as a callback function
      */
     public function FPG_addOptionPage()
     {
         //add_options_page("FlickrPhotogallery", "FlickrPhotogallery", "administrator", "FPG_option_page", array($this,"FPG_configurationForm"));
     
         $page = add_submenu_page('options-general.php', 
                 'FlickrPhotogallery', 
                 'FlickrPhotogallery', 
                 'manage_options', 
                 'FPG_option_page', 
                 array($this, 'FPG_configurationForm'));
         add_action('admin_print_styles-'.$page, array($this,'enqueueAdminStuff'));
     }
     public function enqueueAdminStuff()
     {
        //enqueue color picker
        wp_enqueue_style( 'farbtastic' );
        wp_enqueue_script( 'farbtastic');
     }  
}
$FPG = new FlickrPhotogallery;
?>
