<?php
/*
Plugin Name: Easy Google Maps
Description: With this plugin you can easily insert a google map in your contact page
Version: 1.0
Author: Maurizio Tarchini
Author URI: http://www.mtxweb.ch

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#?DEFINITIONS

define("EGM_PLUGIN_FOLDER_URL", WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),'',plugin_basename(__FILE__)));
define("EGM_TEXDOMAIN", "egm");
define("EGM_SHORTTAG", "[egm-map-position]");


//Plugin output
function egm_insert_map_markup($content)
{
    $replace = '<div id="egm-map-container" style="width:' . get_option('egm-map-width') . 'px;height:' . get_option('emg-map_height') . 'px;"></div>';
    $content = str_replace(EGM_SHORTTAG, $replace, $content);
    return $content;
}

function egm_verify_marker_size()
{
    $size = getimagesize(get_option('egm-image-marker'));
    update_option('egm-marker-width', $size[0]);
    update_option('egm-marker-height', $size[1]);
}

// Set defaults
function egm_on_activate_register_defaults()
{
    add_option('egm-map-width', 500);
    add_option('emg-map_height', 350);
    add_option('egm-lat', 41.891672);
    add_option('egm-lan', 12.492728);
    add_option('egm-ballon-content', '<h2>Title</h2><p>Content</p>');
    add_option('egm-info-window', 'yes');
    add_option('egm-x-corr', 0);
    add_option('egm-y-corr', 0);
    add_option('egm-map-type', 'ROADMAP');
    add_option('egm-start-zoom', 15);
    add_option('egm-marker-width', 36);
    add_option('egm-marker-height', 60);
    add_option('egm-info-on-click', 'yes');
    add_option('egm-image-marker', EGM_PLUGIN_FOLDER_URL . 'images/marker.png' );
}

// register options group
function egm_register_options_group()
{
    register_setting('egm_options_group', 'egm-map-width');
    register_setting('egm_options_group', 'emg-map_height');
    register_setting('egm_options_group', 'egm-lat');
    register_setting('egm_options_group', 'egm-lan');
    register_setting('egm_options_group', 'egm-ballon-content');
    register_setting('egm_options_group', 'egm-info-window');
    register_setting('egm_options_group', 'egm-x-corr');
    register_setting('egm_options_group', 'egm-y-corr');
    register_setting('egm_options_group', 'egm-map-type');
    register_setting('egm_options_group', 'egm-start-zoom');
    register_setting('egm_options_group', 'egm-info-on-click');
    register_setting('egm_options_group', 'egm-image-marker');
}

//js vars
function egm_script_vars()
{
    ?>
    <script type="text/javascript">
        var egmLat = <?php echo get_option('egm-lat'); ?>;
        var egmLan = <?php echo get_option('egm-lan'); ?>;
        var egmBallonContent = '<?php echo get_option('egm-ballon-content'); ?>';
        var egmInfoWindow = '<?php echo get_option('egm-info-window'); ?>';
        var egmXcorr = <?php echo get_option('egm-x-corr'); ?>;
        var egmYcorr = <?php echo get_option('egm-y-corr'); ?>;
        var egmMapType = '<?php echo get_option('egm-map-type'); ?>';
        var egmZoom = <?php echo get_option('egm-start-zoom'); ?>;
        var egmMarkerW = <?php echo get_option('egm-marker-width'); ?>;
        var egmMarkerH = <?php echo get_option('egm-marker-height'); ?>;
        var egmInfoClick = '<?php echo get_option('egm-info-on-click'); ?>';
        var imageUrl = '<?php echo get_option('egm-image-marker'); ?>';
    </script>
    <?php
}

// required scripts
function egm_enqueue_required_scripts()
{
    wp_register_script('egm-google-maps-api', 'http://maps.google.com/maps/api/js?sensor=true');
    wp_enqueue_script('egm-custom-script', EGM_PLUGIN_FOLDER_URL . 'js/egm.script.js', array('egm-google-maps-api', 'jquery'));
    wp_enqueue_style('egm-maps-style', EGM_PLUGIN_FOLDER_URL . 'css/egm.secure.style.css');
}

// options form
function egm_options_form_markup()
{
   ?>
   <div class="wrap">
       <div class="icon32" id="icon-options-general"><br /></div>
       <h2><?php _e('Easy Google Map Configuration', EGM_TEXDOMAIN); ?></h2>
       <p><?php _e('Insert', EGM_TEXDOMAIN); echo ' <strong>' . EGM_SHORTTAG . '</strong> ' ; _e('short-tag in your post', EGM_TEXDOMAIN ); ?></p>
       <p>&nbsp;</p>
       <?php egm_verify_marker_size(); ?>
       <form method="post" action="options.php">
           <?php settings_fields('egm_options_group'); ?>
           <table class="form-table">
               <tbody>
                   <tr valign="top">
                   <th scope="row"><label for="egm-map-width"><?php _e('Map width', EGM_TEXDOMAIN); ?>:</label></th>
                       <td style="width: 230px;">
                           <input type="text" id="egm-map-width" value="<?php echo get_option('egm-map-width'); ?>" name="egm-map-width" /> px 
                       </td>
                       <td>
                       </td>
                   </tr>
                   <tr valign="top">
                   <th scope="row"><label for="emg-map_height"><?php _e('Map height', EGM_TEXDOMAIN); ?>:</label></th>
                       <td>
                           <input type="text" id="emg-map_height" value="<?php echo get_option('emg-map_height'); ?>" name="emg-map_height" /> px  
                       </td>
                        <td>
                       </td>
                   </tr>
                   <tr valign="top">
                   <th scope="row"><label for="egm-lat"><?php _e('Latitude', EGM_TEXDOMAIN); ?>:</label></th>
                       <td>
                           <input type="text" id="egm-lat" value="<?php echo get_option('egm-lat'); ?>" name="egm-lat" />  
                       </td>
                        <td>
                       </td>
                   </tr>
                   <tr valign="top">
                   <th scope="row"><label for="egm-lan"><?php _e('Longitude', EGM_TEXDOMAIN); ?>:</label></th>
                       <td>
                           <input type="text" id="egm-lan" value="<?php echo get_option('egm-lan'); ?>" name="egm-lan" />  
                       </td>
                        <td>
                       </td>
                   </tr>
                    <td>
                       </td>
                   <tr valign="top">
                   <th scope="row"><label for="egm-image-marker"><?php _e('Marker image', EGM_TEXDOMAIN); ?>:</label></th>
                       <td>
                           <input type="hidden" id="egm-image-marker" value="<?php echo get_option('egm-image-marker'); ?>" name="egm-image-marker" />  
                           <input id="upload_image_button" type="button" class="button" value="<?php _e('Upload Marker Image', EGM_TEXDOMAIN); ?>" /> <img src="<?php echo get_option('egm-image-marker');?>" alt="marker" height="30" class="alignright" id="egm-imarker" />
                       </td>
                        <td>
                       </td>
                   </tr>
                   
                   <tr valign="top">
                   <th scope="row"><label for="egm-start-zoom"><?php _e('Zoom', EGM_TEXDOMAIN); ?>:</label></th>
                       <td>
                           <input type="text" id="egm-start-zoom" value="<?php echo get_option('egm-start-zoom'); ?>" name="egm-start-zoom" />  
                       </td>
                        <td>
                       </td>
                   </tr>
                   
                   <tr valign="top">
                   <th scope="row"><label for="egm-x-corr"><?php _e('X Correction', EGM_TEXDOMAIN); ?>:</label></th>
                       <td>
                           <input type="text" id="egm-x-corr" value="<?php echo get_option('egm-x-corr'); ?>" name="egm-x-corr" />  
                       </td>
                        <td>
                       </td>
                   </tr>
                   
                   <tr valign="top">
                   <th scope="row"><label for="egm-y-corr"><?php _e('Y Correction', EGM_TEXDOMAIN); ?>:</label></th>
                       <td>
                           <input type="text" id="egm-y-corr" value="<?php echo get_option('egm-y-corr'); ?>" name="egm-y-corr" />  
                       </td>
                        <td>
                       </td>
                   </tr>
                   
                   <tr valign="top">
                       <th scope="row"><label for="egm-map-type"><?php _e('Map type', EGM_TEXDOMAIN); ?>:</label></th>
                           <td>
                               <select id="egm-map-type" name="egm-map-type" style="width: 134px;">
                                   <option value="ROADMAP" <?php selected(get_option('egm-map-type'), "ROADMAP"); ?>><?php _e('Road Map', EGM_TEXDOMAIN); ?> </option>
                                   <option value="SATELLITE" <?php selected(get_option('egm-map-type'), "SATELLITE"); ?>><?php _e('Satellite', EGM_TEXDOMAIN); ?> </option>
                               </select>
                               <span class="description"></span>    
                           </td>
                           <td>
                           </td>
                   </tr>
                   
                   <tr valign="top">
                       <th scope="row"><label for="egm-info-window"><?php _e('Use info window', EGM_TEXDOMAIN); ?>:</label></th>
                           <td>
                               <select id="egm-info-window" name="egm-info-window" style="width: 134px;">
                                   <option value="yes" <?php selected(get_option('egm-info-window'), "yes"); ?>><?php _e('Yes', EGM_TEXDOMAIN); ?> </option>
                                   <option value="no" <?php selected(get_option('egm-info-window'), "no"); ?>><?php _e('No', EGM_TEXDOMAIN); ?> </option>
                               </select>
                               <span class="description"></span>    
                           </td>
                           <td>
                           </td>
                   </tr>
                   
                   <tr valign="top">
                       <th scope="row"><label for="egm-info-on-click"><?php _e('Open info window', EGM_TEXDOMAIN); ?>:</label></th>
                           <td>
                               <select id="egm-info-on-click" name="egm-info-on-click" style="width: 134px;">
                                   <option value="yes" <?php selected(get_option('egm-info-on-click'), "yes"); ?>><?php _e('On click', EGM_TEXDOMAIN); ?> </option>
                                   <option value="no" <?php selected(get_option('egm-info-on-click'), "no"); ?>><?php _e('On load', EGM_TEXDOMAIN); ?> </option>
                               </select>
                               <span class="description"></span>    
                           </td>
                           <td>
                           </td>
                   </tr>
           
                   <tr valign="top">
                       <th scope="row"><label for="egm-ballon-content"><?php _e('Info window content', EGM_TEXDOMAIN); ?><br /><span class="description"><?php _e('(You can use html tags)', EGM_TEXDOMAIN); ?></span></label></th>
                           <td>
                               <textarea id="egm-ballon-content" name="egm-ballon-content" style="width:200px; height:120px"><?php echo get_option('egm-ballon-content'); ?></textarea>
                               <span class="description"></span>    
                           </td>
                   </tr>
                   <tr valign="top">
                       <th scope="row"></th>
                           <td>
                               <p class="submit">
                                   <input type="submit" class="button-primary" id="submit" name="submit" value="<?php _e('Save Changes') ?>" />
                               </p>
                           </td>
                   </tr>
               </tbody>
           </table>
           
       </form>
   </div>
   <?php
}

// add option page
function egm_add_option_page()
{
   add_options_page(__('Easy Google Map Configuration', EGM_TEXDOMAIN), __('Easy Google Map', EGM_TEXDOMAIN), 'administrator', 'egm-options-page', 'egm_options_form_markup');
}

// upload plugin
function egm_load_admin_scripts() 
{
    wp_enqueue_script('media-upload');
    wp_enqueue_script('thickbox');
    wp_register_script('egm-upload-script', EGM_PLUGIN_FOLDER_URL . 'js/egm.upload.script.js', array('jquery','media-upload','thickbox'));
    wp_enqueue_script('egm-upload-script');
}

function egm_uploader_style() 
{
    wp_enqueue_style('thickbox');
}


// plugin translation
function egm_load_local_texdomain()
{
    load_plugin_textdomain(EGM_TEXDOMAIN, false, dirname( plugin_basename( __FILE__ )) . '/languages/');
}


///////////////-- ACTIONS AND FILTER -- ///////////////////
add_action('admin_init', 'egm_register_options_group');
add_action('admin_menu', 'egm_add_option_page');

if(!is_admin())
{
    add_action('init', 'egm_enqueue_required_scripts');
    add_action('wp_print_scripts', 'egm_script_vars');
    add_filter('the_content', 'egm_insert_map_markup');
}


//////////// --- ACTIONS AND FILTER OPTIONS PAGE REQUIRED ---- ////////////


if (isset($_GET['page']) && $_GET['page'] == 'egm-options-page') 
{
    add_action('admin_print_scripts', 'egm_load_admin_scripts');
    add_action('admin_print_styles', 'egm_uploader_style');

}


    add_action('init', 'egm_load_local_texdomain');
// install
register_activation_hook( __FILE__, 'egm_on_activate_register_defaults');
?>