
jQuery(document).ready(function($){	
    if($('#egm-map-container').length > 0)
    {
        var miaPosizione = new google.maps.LatLng(egmLat,egmLan);
        var mtid;
        if(egmMapType == "ROADMAP")
        {
            mtid = google.maps.MapTypeId.ROADMAP;
        }
        else
        {
            mtid = google.maps.MapTypeId.SATELLITE;
        }
        var settings = {
        				zoom: egmZoom,
        				center: miaPosizione,
        				mapTypeControl: true,
        				mapTypeControlOptions: {style: google.maps.MapTypeControlStyle.DROPDOWN_MENU},
        				navigationControl: true,
        				navigationControlOptions: {style: google.maps.NavigationControlStyle.SMALL},
        				mapTypeId: mtid};
        
        var map = new google.maps.Map(document.getElementById("egm-map-container"), settings);
        	
        var mioLogo = new google.maps.MarkerImage(	imageUrl,
        											new google.maps.Size(egmMarkerW,egmMarkerH),
        											new google.maps.Point(egmXcorr,egmYcorr)
        											);
        
        
        var mioMarker = new google.maps.Marker({
        					position: miaPosizione,
        					map: map,
        					icon: mioLogo,
        			});
        
    
        if(egmInfoWindow == "yes")
        {
            var infobox = new google.maps.InfoWindow({
            content: '<div id="egm-map-info">'+egmBallonContent+'</div>'
            });
        
            if(egmInfoClick == "yes")
            {
                google.maps.event.addListener(mioMarker, 'click', function() {
                infobox.open(map,mioMarker);
                google.maps.event.trigger(map, 'resize');
                 });
            }
            else
            {
                infobox.open(map,mioMarker);
                google.maps.event.trigger(map, 'resize');
            }
           
        } 
        
    }
});