<?php
/*
Plugin Name: YIW Numbers Widget
Plugin Script: yiw.numbers.widget.php
Description: Grazie a questo widget potrai pubblicare nella sidebar i tuoi numeri telefonici
Version: 1.0
License: GPL 2.0
Author: Maurizio Tarchini
*/

class yiw_numbers_widget extends WP_Widget
{
	public function __construct() 
    {
		parent::WP_Widget( 'yiw-numbers', 'YIW NUMBERS', array('description' => 'Grazie a questo widget é possibile visualizzare i numeri telefonici sulla sidebar'));
	}
	
	public function form( $instance )
	{
        /* Impostazioni di default del widget */
		$defaults = array( 
            'title' => 'Contatti',
            'phone' => NULL,
            'mobile' => NULL,
            'fax' => NULL
        );
        
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				Titolo:
			</label>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
			
		</p>
		<p>&nbsp;</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'phone' ); ?>">
				Telefono:
			</label>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'phone' ); ?>" name="<?php echo $this->get_field_name( 'phone' ); ?>" value="<?php echo $instance['phone']; ?>" />
			
		</p>  

		<p>
			<label for="<?php echo $this->get_field_id( 'mobile' ); ?>">
				Mobile:
			</label>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'mobile' ); ?>" name="<?php echo $this->get_field_name( 'mobile' ); ?>" value="<?php echo $instance['mobile']; ?>" />
			
		</p> 
		
		<p>
			<label for="<?php echo $this->get_field_id( 'fax' ); ?>">
				Fax:
			</label>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'fax' ); ?>" name="<?php echo $this->get_field_name( 'fax' ); ?>" value="<?php echo $instance['fax']; ?>" />
			
		</p>
		
	            
		<?php
	}
	
	public function widget( $args, $instance )
	{
		
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		
		echo $before_widget;
		echo $before_title . $title . $after_title;
		?>
			<div class="yiw-numbers-widget">
				<p><strong>Telefono</strong>: <?php echo $instance['phone']; ?></p>
				<p><strong>Mobile</strong>: <?php echo $instance['mobile']; ?></p>
				<p><strong>Fax</strong>: <?php echo $instance['fax']; ?></p>			
			</div>
		<?php
		echo $after_widget;
	}
	
	public function update( $new_instance, $old_instance ) 
    {
		$instance = $old_instance;

		$instance['title'] = strip_tags( $new_instance['title'] );

		$instance['phone'] = strip_tags( $new_instance['phone'] );
		
		$instance['mobile'] = strip_tags( $new_instance['mobile'] );
		
		$instance['fax'] = strip_tags( $new_instance['fax'] );

		return $instance;
	}                     
}

function yiw_numbers_register_widgets()
{
	register_widget( 'yiw_numbers_widget' );
}

add_action( 'widgets_init', 'yiw_numbers_register_widgets' );
?>