<?php
/**
 * Document: index.php
 * Created on: 13-dic-2011, 11:03
 * Author : Nicola Mustone <mustone.nicola@gmail.com>
   		    per Your Inspiration Web [http://www.yourinspirationweb.com]
 * Description: File di esempio per l'utilizzo della classe YCFile.
 */
require_once('file.php');

//Definisco questa costante per comodità così scriverò DS invece di DIRECTORY_SEPARATOR
define('DS', DIRECTORY_SEPARATOR);
?>
<!DOCTYPE html>
<html>
<head>
	<title>Gestire i file con la classe YCFile (Parte 2)</title>
    <meta http-equiv="content-type" content="text/html;charset=utf-8;">
    <meta name="author" content="Nicola Mustone <mustone.nicola@gmail.com> per Your Inspiration Web [http://www.yourinspirationweb.com] " />
    <meta name="description" content="File di esempio per l'utilizzo della classe YCFile realizzata per Your Inspiration Web." />
    <style>
	@charset "UTF-8";
    pre {
		display: block;
		padding: 5px;
		border: 1px solid #666;
		background-color: #ECECEC;
	}
    </style>
</head>
<body>
<?php
$pathCompleta = '.' . DS . 'file' . DS . 'textfile.txt';

//Controllo l'esistenza del file di esempio textfile.txt
if(YCFile::find($pathCompleta, './')) {
	
	$leggibile = (YCFile::isReadable($pathCompleta)) ? 'è leggibile' : 'non è leggibile';;
	$nomeFile = YCFile::name($pathCompleta);
	$estensioneFile = YCFile::ext($pathCompleta);
	
	//Posso anche fare $nomeFile . '.' . $estensioneFile
	//Ma voglio mostrarti l'utilità del metodo YCFile::realName().
	$nomeCompletoFile = YCFile::realName($pathCompleta);
	?>
    <div>
    	<h1>File <?php echo $nomeCompletoFile; ?></h1>
        <p>
        	Il file <?php echo $nomeFile . ' ' . $leggibile; ?>.<br/>
            La sua estensione è <?php echo $estensioneFile; ?>.
        </p>
        <h2>Ed ecco il suo contenuto</h2>
        <p>
        	<?php echo YCFile::read($pathCompleta); ?>
        </p>
        </div>
    <?php
	//Se vuoi testare anche questo metodo, decommenta la linea successiva.
	//echo (YCFile::delete($pathCompleta)) ? '<h3>File eliminato correttamente</h3>' : '<h3>Impossibile eliminare il file</h3>';
}
?>
<div>
	<h2>Nella cartella <strong>file</strong> sono presenti i seguenti file:</h2>
    <ul>
    <?php
	if(YCFile::listFile('./file/') !== FALSE) {
		$files = YCFile::listFile('./file/');
		foreach($files as $nomeFileAttuale => $percorsoFileAttuale) {
			echo '<li>' . $nomeFileAttuale . ' (Path => ' . $percorsoFileAttuale .')</li>';
		}
	}
	?>
    </ul>
<div>
	<p>
    	Ecco il codice utilizzato per l'esempio:
<pre>
&lt;?php
$pathCompleta = '.' . DS . 'file' . DS . 'textfile.txt';

//Controllo l'esistenza del file di esempio textfile.txt
if(YCFile::find($pathCompleta, './')) {
	
	$leggibile = (YCFile::isReadable($pathCompleta)) ? 'è leggibile' : 'non è leggibile';;
	$nomeFile = YCFile::name($pathCompleta);
	$estensioneFile = YCFile::ext($pathCompleta);
	
	//Posso anche fare $nomeFile . '.' . $estensioneFile
	//Ma voglio mostrarti l'utilità del metodo YCFile::realName().
	$nomeCompletoFile = YCFile::realName($pathCompleta);
	?&gt;
	&lt;div&gt;
            &lt;h1&gt;File &lt;?php echo $nomeCompletoFile; ?&gt;&lt;/h1&gt;
            &lt;p&gt;
                Il file &lt;?php echo $nomeFile . ' ' . $leggibile; ?&gt;.&lt;br/&gt;
                La sua estensione è &lt;?php echo $estensioneFile; ?&gt;.
            &lt;/p&gt;
            &lt;h2&gt;Ed ecco il suo contenuto&lt;/h2&gt;;
            &lt;p&gt;
                &lt;?php echo YCFile::read($pathCompleta); ?&gt;
            &lt;/p&gt;
            &lt;/div&gt;
	&lt;?php
	//Se vuoi testare anche questo metodo, decommenta la linea successiva.
	//echo (YCFile::delete($pathCompleta)) ? '&lt;h3&gt;File eliminato correttamente&lt;/h3&gt;' : '&lt;h3&gt;Impossibile eliminare il file&lt;/h3&gt;';
}
?&gt;
&lt;div&gt;
	&lt;h2&gt;Nella cartella &lt;strong&gt;file&lt;/strong&gt; sono presenti i seguenti file:&lt;/h2&gt;
    &lt;ul&gt;
    &lt;?php
	if(YCFile::listFile('./file/') !== FALSE) {
		$files = YCFile::listFile('./file/');
		foreach($files as $nomeFileAttuale =&gt; $percorsoFileAttuale) {
			echo '&lt;li&gt;' . $nomeFileAttuale . ' (' . $percorsoFileAttuale .')&lt;/li&gt;';
		}
	}
    ?&gt;
</pre>
    </p>
</div>
</div>
</body>
</html>
<script type="text/javascript">
var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
</script>
<script type="text/javascript">
try {
var pageTracker = _gat._getTracker("UA-8632327-1");
pageTracker._trackPageview();
} catch(err) {}</script>