$(document).ready(function(){
    $('#uidRow, #psidRow').hide();
    $('#source').change(showFields);
    $('#idFinder').click(function(){
       var checkSource = $('#source').val();
       var x = prompt(checkSource.match(/(user|photoset)/) ? 'Enter the URL of your flickr account' : 'Enter the URL of your flickr group', 
                      checkSource.match(/(user|photoset)/) ? 'http://flickr.com/photos/your_username/' : 'http://flickr.com/groups/your_group/');
       if(!x) return false;
       var url = "http://api.flickr.com/services/rest/?"+
                "method="+(checkSource.match(/(user|photoset)/) ? "flickr.urls.lookupUser&" : "flickr.urls.lookupGroup&")+
                "api_key=6797f60abafb94a1ffa22d49f3c7851d&"+
                "format=json&"+
                "jsoncallback=?&"+
                "url="+x;
       $.getJSON(url, function(result){
           if (result.stat != 'ok')
           {
               alert('Problems occurred retrieving your id, please try again');
               return false;
           }
           $('#uid').val(checkSource.match(/(user|photoset)/) ? result.user.id : result.group.id);
        });
    });
    
    // FORM SUBMIT
    $('#yifForm').submit(function(){
        var querystring = $(this).serialize();
        $.ajax({
            type: 'POST',
            url: './include/process.php',
            data: querystring,
            success: function(response){
                $('#content').html(response);
                $('a[rel=FlickrGallery]').fancybox({
                    titleShow: true,
                    titlePosition: 'over'
                });
            },
            error: function(){
                $('#content').html('Something went wrong!');
            }
        });
        return false;
    })

    function showFields()
    {
        var checkSource = $('#source').val();
        switch(checkSource)
        {
            case('public'):
                $('#uidRow, #psidRow').hide();
                break;
            case('user'):
            case('group'):
                if($('#psidRow').is(':visible'))
                {
                    $('#psidRow').hide();
                }
                $('#uidRow').show();
                $('#uidRow label').text(checkSource == 'user' ? 'Your User Id:' : 'Your Group Id:');
                break;
            case('photoset'):
                $('#uidRow, #psidRow').show();
                $('#uidRow label').text('Your User Id:');
                break;
        }
    }
})


