<?php
/*
Plugin Name: PostPlus
Plugin Script: post.plus.widget.php
Description: This widget show the last post and the most commented post.
Version: 1.0
License: GPL 3.0
Author: Maurizio Tarchini
*/

//Plugin safe location
$location = WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),'',plugin_basename(__FILE__));
define("PP_PLUGIN_FOLDER_URL", $location);



class pp_post_plus_widget extends WP_Widget
{
	public function __construct() 
    {
        load_plugin_textdomain('pp-textdomain', false, dirname( plugin_basename( __FILE__ )) . '/languages');
        $description = __('This widget show the last post and the most commented post','pp-textdomain');
		parent::WP_Widget( 'pp-post-plus', 'PostPlus', array('description' => $description));
	}
	
	public function form( $instance )
	{
		
		$defaults = array( 
            'title' => 'PostPlus',
			'title_post' => 'Last articles',
            'num_post' => 5,
            'title_most_comment' => 'Most commented',
            'num_most_comment' => 5
        );
        
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<strong><?php _e('Title', 'pp-textdomain'); ?>:</strong>
			</label>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
			
		</p>	
		<p>&nbsp;</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'title_post' ); ?>">
				<?php _e('Title for "last post"', 'pp-textdomain'); ?>:
			</label>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title_post' ); ?>" name="<?php echo $this->get_field_name( 'title_post' ); ?>" value="<?php echo $instance['title_post']; ?>" />
			
		</p>		
		<p>
			<label for="<?php echo $this->get_field_id( 'num_post' ); ?>">
				<?php _e('Number of post', 'pp-textdomain'); ?>:
			</label>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'num_post' ); ?>" name="<?php echo $this->get_field_name( 'num_post' ); ?>" value="<?php echo $instance['num_post']; ?>" />
			
		</p>
			<p>
			<label for="<?php echo $this->get_field_id( 'title_most_comment' ); ?>">
				<?php _e('Title for "most commented"', 'pp-textdomain'); ?>:
			</label>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title_most_comment' ); ?>" name="<?php echo $this->get_field_name( 'title_most_comment' ); ?>" value="<?php echo $instance['title_most_comment']; ?>" />
			
		</p>		
		<p>
			<label for="<?php echo $this->get_field_id( 'num_most_comment' ); ?>">
				<?php _e('Number of post', 'pp-textdomain'); ?>:
			</label>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'num_most_comment' ); ?>" name="<?php echo $this->get_field_name( 'num_most_comment' ); ?>" value="<?php echo $instance['num_most_comment']; ?>" />
			
		</p>        
		<?php
		
	}
	
	private function _getLastPost($instance)
	{
		global $wpdb;
		$sql = 'SELECT * FROM ' . $wpdb->posts . ',' . $wpdb->users . 
		' WHERE ' . $wpdb->posts . '.post_author=' . $wpdb->users . '.ID AND ' . $wpdb->posts . '.post_type=\'post\'
		 ORDER BY ' . $wpdb->posts . '.post_date DESC 
		 LIMIT 0,' . $instance['num_post'];
		
		$result = $wpdb->get_results($sql);
		foreach($result as $res)
		{
			echo '<li>
			<a href="' . $res->guid . '">' . $res->post_title . '</a> | 
			di: <strong>' . $res->display_name . '</strong> | 
			' . mysql2date('j F Y', $res->post_date)  . '</li>';
		}
	}
	
	private function _getMostComment($instance)
	{
		global $wpdb;
		$sql = 'SELECT post_title,guid,comment_count FROM ' . $wpdb->posts . 
		' WHERE post_type=\'post\'
		 ORDER BY comment_count DESC 
		 LIMIT 0,' . $instance['num_most_comment'];
		
		$result = $wpdb->get_results($sql);
		foreach($result as $res)
		{
			echo '<li>
			<a href="' . $res->guid . '">' . $res->post_title . '</a>
			 <strong>(' . $res->comment_count . ')</strong></li>';
		}
	}
	
	public function widget( $args, $instance )
	{
		
		
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		
		echo $before_widget;
		echo $before_title . $title . $after_title;
		?>
			<div id="pp-tabs-container">
				<ul>
					<li><a href="#pp-tab-1"><?php echo $instance['title_post']; ?></a></li>
					<li><a href="#pp-tab-2"><?php echo $instance['title_most_comment']; ?></a></li>
				</ul>
				<div id="pp-tab-1">
                    <ul>
                        <?php $this->_getLastPost($instance); ?>
				    </ul>
                </div>
				<div id="pp-tab-2">
                    <ul>
                        <?php $this->_getMostComment($instance); ?>
                    </ul>
				</div>			
			</div>
		<?php
		echo $after_widget;
		
	}
	
	
	
	public function update( $new_instance, $old_instance ) 
    {
		
		$instance = $old_instance;

		$instance['title'] = strip_tags( $new_instance['title'] );
		
		$instance['title_post'] = strip_tags( $new_instance['title_post'] );

		$instance['num_post'] = strip_tags( $new_instance['num_post'] );
		
		$instance['title_most_comment'] = strip_tags( $new_instance['title_most_comment'] );

		$instance['num_most_comment'] = strip_tags( $new_instance['num_most_comment'] );


		return $instance;
		
	}                     
}


function pp_post_plus_register_widget()
{
	register_widget( 'pp_post_plus_widget' );
}


function pp_post_plus_enqueue_required_scripts()
{
    wp_enqueue_script('pp-tabs', PP_PLUGIN_FOLDER_URL . 'pp.jquery.tabs.js', array('jquery-ui-tabs'));
    wp_enqueue_style('pp-ui-style', PP_PLUGIN_FOLDER_URL . 'css/jquery.ui.custom.css');
}



add_action('wp_enqueue_scripts', 'pp_post_plus_enqueue_required_scripts');


add_action( 'widgets_init', 'pp_post_plus_register_widget' );





?>