<?php
/**
 * Document: index.php
 * Created on: 30-gen-2012, 17:01
 * Author : Nicola Mustone <mustone.nicola@gmail.com>
   		    per Your Inspiration Web [http://www.yourinspirationweb.com]
 * Description: File di esempio per la classe class.gravatar.
 */
require_once("class.gravatar.php");
?>
<!DOCTYPE html>
<html>
<head>
	<title>Sfruttare le API di Gravatar</title>
    <meta http-equiv="content-type" content="text/html;charset=utf-8;">
    <meta name="author" content="Nicola Mustone <mustone.nicola@gmail.com> per Your Inspiration Web [http://www.yourinspirationweb.com] " />
    <meta name="description" content="File di esempio per la classe Gravatar" />
    <style>
	@charset "UTF-8";
    pre {
		display: block;
		padding: 5px;
		border: 1px solid #666;
		background-color: #ECECEC;
	}
    </style>
</head>
<body>
<h1>Utilizzo della classe Gravatar</h1>
<?php
$gravatar = new Gravatar();

$gravatar->useSSL = false;
$gravatar->imgWrapper = true;
$gravatar->setEmail('mustone.nicola@gmail.com');
$gravatar->setDefault('mm');
$gravatar->setSize(100);
$gravatar->setRating('g');

$extras = array(
	'class' => 'myAvatar',
	'title' => 'Il mio avatar',
	'alt' => 'Nicola Mustone'
);

$gravatar->setExtras($extras);
echo $gravatar->getGravatar();
?>
<p>
	Ecco il codice utilizzato per l'esempio:
<pre>
&lt;php
require_once("class.gravatar.php");

$gravatar = new Gravatar();

$gravatar-&gt;useSSL = false;
$gravatar-&gt;imgWrapper = true;
$gravatar-&gt;setEmail('mustone.nicola@gmail.com');
$gravatar-&gt;setDefault('mm');
$gravatar-&gt;setSize(100);
$gravatar-&gt;setRating('g');

$extras = array(
	'class' =&gt; 'myAvatar',
	'title' =&gt; 'Il mio avatar',
	'alt' =&gt; 'Nicola Mustone'
);

$gravatar->setExtras($extras);
echo $gravatar->getGravatar();
?&gt;
</pre>
Volendo, puoi abbreviare il tutto in questo modo:
<pre>
&lt;php
require_once("class.gravatar.php");

$gravatar = new Gravatar('mustone.nicola@gmail.com');
$gravatar-&gt;imgWrapper = true;
$gravatar-&gt;setSize(100);

echo $gravatar;
?&gt;
</pre>
</p>
</body>
</html>