<?php
// 1. Includere la classe easy_form
include_once 'easy.form.class.php';

// 2. Istanziare la classe easy_form
// al costruttore possono essere passati una serie di parametri in forma di array associativo (parametro => valore)
// i parametri sono i seguenti:
//
// method(string): il metodo di invio dati / default "post"
// action(string): La pagina alla quale punta il form / default: la stessa pagina (PHP_SELF)
// prefix(string): prefisso per id e classi / default: ef- (se dovessero esserci due form sulla stessa pagina, cambiare il prefisso)
// html5(bool): utilizza le caratteristiche form di html5 (richiede il doctype html5) / default: false
// inline(bool): visualizza le label inline ai campi (true) o sopra i campi (false) / default: true
// language(string): Sigla del linguaggio da utilizzare / default it
// ajax(mixed): se si intende inviare i dati con chiamata asincrona inserire il percorso al file che si occupa di elaborare i dati / default: false
// qualora si utilizzasse ajax, editare il file js/success.js che contiene la funzione di callback 
// Ajax richiede jQuery (_loadjQuery) ed il metodo _loadScript
//
// Dunque, se ad esempio se volessi utilizzare il metodo get, le proprietà di html5, e il linguaggio inglese, dovrei istanziare così
// $form = new easy_form(array('method' => 'get', 'html5' => true, 'language' => 'en'));
//
// per l'esempio istanzio con i parametri di default
 $form = new easy_form();

// 3. il metodo _have_errors restituisce true se vi sono degli errori 
// nella validazione lato server
// quindi può essere usato in negazione per eseguire le operazioni necessarie se i dati hanno passato i controlli
if(!$form->_have_errors())
{
    // registra il nuovo utente
    // oppure invia il contact form
    // oppure ....
    
    // reindirizza ad una pagina
    // oppure, se si intende rimanere in questa pagina, é ppossibile utilizzare
    // il metodo _success passando come paramentro quello che si vuole far apparire
    // nel box delle informazioni del form

    $form->_success('Registrazione avvenuta');
}
?>
<!DOCTYPE html>
<html dir="ltr" lang="it-IT">
<head>
    <meta charset="utf-8" />
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <meta name="author" content="Maurizio Tarchini" />
        
    <?php 
    // 4. Carica il foglio di stile
    // senza parametri carica il foglio di stile di default
    // é possibile passare il nome di un altro foglio di stile come paramentro
    $form->_loadStyle('css/ef-base.css'); 
    ?>
    <style>
        #container{margin: 0px auto; width: 960px;}
        body{margin-top: 40px;}
    </style>
    <?php
    // 5. Validazione lato client
    // Se si desidera la validazione lato client:
    // caricare jQuery tramite il metodo _loadjQuery se la pagina non lo prevede già
    // caricare lo script di validazione con il metodo _loadScript
    // esay form é in grado di riconoscere e validare i vari campi presenti 
    $form->_loadjQuery();
    $form->_loadScripts(); ?>

    <title>Sample Form</title>

    
</head>

<body>
    <div id="container">
        <?php 
        // 6. Utilizzare uno dei metodi
        // _simpleRegistrationForm(titolo del form, value del tasto submit)
        // _simpleContactForm(titolo del form, value del tasto submit)
        // _simpleLoginForm(titolo del form, value del tasto submit)
        
        //Decommenta la prossima riga per provare il form di registrazione
        //$form->_simpleRegistrationForm('Registrati al nostro sito', 'Invia');
        
        //Decommenta la prossima riga per provare il form di contatto
        // $form->_simpleContactForm(Contattami, Invia)
        
        // Decommenta la prossima riga per provare il form di login
        // $form->_simpleLoginForm(Login, Login)
        
        // oppure il metodo _customForm() che permette di creare un form personalizzato
        // _customForm(titolo del form, value del tasto submit, campi)
        // i campi sono da esmprimere in forma di array associativo "tipo di campo" => "label del campo"
        // i tipi di campo sono name,email,message,url,phone,password,password2
        // esempio, se volessi un form di contatto con nome, email, sito web, numero di telefono e messaggio
        //
        // Decommenta la prossima riga per provare il custom form
        //$form->_customForm('Contattami', 'Invia', array('name' => 'Nome e Cognome', 'email' => 'Email', 'url' => 'sito web', 'phone' => 'Telefono', 'message' => 'Messaggio')); 
        ?>
    
    </div>
</body>
</html>