<?php

/**
 * easy_form
 * 
 * @package easy-form
 * @author Tarchini Maurizio
 * @copyright 2012
 * @version 1.0
 * @access public
 * @license GPL 3.0
 * @name easy.form.class
 */
 
class easy_form
{
    protected $opt;
    protected $br;
    protected $name_value;
    protected $email_value;
    protected $message_value;
    protected $url_value;
    protected $phone_value;
    protected $password_value;
    protected $password2_value;
    protected $regExpName;
    protected $regExpEmail;
    protected $regExpPhone;
    protected $regExpUrl;
    protected $errorReg;
    protected $errorMsg;
    protected $errorEmpty;
    protected $errorLang;
    protected $formLang;
    protected $successMsg;
    public $login_error;
    
        /**
         * easy_form::__construct()
         * 
         * @param array $options
         * @return void
         */
        public function __construct($options = array())
        {
            $this->name_value = "";
            $this->email_value = "";
            $this->message_value = "";
            $this->url_value = "";
            $this->phone_value = "";
            $this->password_value = "";
            $this->password2_value = "";
            $this->errorReg = FALSE;
            $this->errorEmpty = FALSE;
            $this->errorMsg = "";
            $this->login_error = FALSE;
            
            $page = basename($_SERVER['PHP_SELF']);
            
            $defaults = array(  'method' => 'post',
                                'action' => $page,
                                'prefix' => 'ef-',
                                'html5' => false,
                                'inline' => true,
                                'language' => 'it',
                                'ajax' => false,
                                'name' => true,
                                'email' => true,
                                'message' => true,
                                'url' => true,
                                'phone' => true,
                                'password' => true,
                                'password2' => true,
                                'message-limit' => false,
                                'password-test' => false);
                                
            $this->opt = array_merge($defaults,(array)$options);
            
            include dirname(__FILE__) . '/lib/regExp.php';
            
            $this->errorLang = file(dirname(__FILE__) . '/languages/error.' . $this->opt['language'] . '.txt');
            $this->formLang = file(dirname(__FILE__) . '/languages/form.' . $this->opt['language'] . '.txt');
            
            if(!$this->opt['inline'])
            {
                $this->br = '<br class="' . $this->opt['prefix'] . 'br" />
                ';
            }
            else
            {
                $this->br = '';
            }
            
            if(isset($_REQUEST[$this->opt['prefix'] . 'submit']))
            {
                if(isset($_REQUEST[$this->opt['prefix'] . 'name']))
                {
                    $this->name_value = trim($_REQUEST[$this->opt['prefix'] . 'name']);
                    $this->validateName();
                }
                if(isset($_REQUEST[$this->opt['prefix'] . 'email']))
                {
                    $this->email_value = trim($_REQUEST[$this->opt['prefix'] . 'email']);
                    $this->validateEmail();
                }
                if(isset($_REQUEST[$this->opt['prefix'] . 'message']))
                {
                    $this->message_value = trim($_REQUEST[$this->opt['prefix'] . 'message']);
                    $this->validateMessage();
                }
                if(isset($_REQUEST[$this->opt['prefix'] . 'url']))
                {
                    $this->url_value = trim($_REQUEST[$this->opt['prefix'] . 'url']);
                    $this->validateUrl();
                }
                if(isset($_REQUEST[$this->opt['prefix'] . 'phone']))
                {
                    $this->phone_value = trim($_REQUEST[$this->opt['prefix'] . 'phone']);
                    $this->validatePhone();
                }
                if(isset($_REQUEST[$this->opt['prefix'] . 'password']) && isset($_REQUEST[$this->opt['prefix'] . 'password2']))
                {
                    $this->password_value = trim($_REQUEST[$this->opt['prefix'] . 'password']);
                    $this->password2_value = trim($_REQUEST[$this->opt['prefix'] . 'password2']);
                    $this->validatePassword();
                }
                
                if($this->errorEmpty)
                {
                    $this->errorMsg .= $this->errorLang[0] . '<br />
                    ';
                }
               
            }
        }
        
        /**
         * easy_form::_have_errors()
         * 
         * return TRUE if validation errors are found
         * @return bool
         * @since 1.0
         */
        public function _have_errors()
        {
            return $this->errorReg;
        }
        
        /**
         * easy_form::_success()
         * 
         * displays the success message and reset the array request
         * @param mixed $message
         * @return void
         * @since 1.0
         */
        public function _success($message)
        {
            $this->successMsg = $message;
            $this->name_value = "";
            $this->email_value = "";
            $this->url_value = "";
            $this->phone_value = "";
            $this->message_value = "";
        }
        
        /**
         * easy_form::validateName()
         * 
         * Validate field name
         * @return void
         * @since 1.0
         */
        protected function validateName()
        {
            if($this->name_value == "")
            {
                if($this->opt['name'])
                {
                    $this->errorReg = TRUE;
                    $this->errorEmpty = TRUE;
                }
                
            }
            else
            {
                if(!preg_match($this->regExpName,$this->name_value))
                {
                    $this->errorMsg .= $this->errorLang[4] . '<br />
                    ';
                    $this->errorReg = TRUE;
                }
            }
        }
        
        /**
         * easy_form::validatePassword()
         * 
         * Validate field password
         * @return void
         * @since 1.0
         */
        protected function validatePassword()
        {
            if($this->password_value == "" OR $this->password2_value == "")
            {
                $this->errorReg = TRUE;
                $this->errorEmpty = TRUE;
            }
            else
            {
                if($this->password_value != $this->password2_value)
                {
                    $this->errorMsg .= $this->errorLang[5] . '<br />
                    ';
                    $this->errorReg = TRUE;
                }
            }
        }
        
        /**
         * easy_form::validateEmail()
         * 
         * Validate email field
         * @return void
         * @since 1.0
         */
        protected function validateEmail()
        {
            if($this->email_value == "")
            {
                if($this->opt['email'])
                {
                    $this->errorReg = TRUE;
                    $this->errorEmpty = TRUE;
                }
                
            }
            else
            {
                if(!preg_match($this->regExpEmail,$this->email_value))
                {
                    $this->errorMsg .= $this->errorLang[1] . '<br />
                    ';
                    $this->errorReg = TRUE;
                }
            }
        }
        
        /**
         * easy_form::validateUrl()
         * 
         * Validate url field
         * @return void
         * @since 1.0
         */
        protected function validateUrl()
        {
            if($this->url_value == "")
            {
                if($this->opt['url'])
                {
                    $this->errorReg = TRUE;
                    $this->errorEmpty = TRUE;
                }
                
            }
            else
            {
                if(!preg_match($this->regExpUrl,$this->url_value))
                {
                    $this->errorMsg .= $this->errorLang[2] . '<br />
                    ';
                    $this->errorReg = TRUE;
                }
            }
        }
        
        /**
         * easy_form::validatePhone()
         * 
         * Validate phone field
         * @return void
         * @since 1.0
         */
        protected function validatePhone()
        {
            if($this->phone_value == "")
            {
                if($this->opt['phone'])
                {
                    $this->errorReg = TRUE;
                    $this->errorEmpty = TRUE;
                }  
            }
            else
            {
                if(!preg_match($this->regExpPhone,$this->phone_value))
                {
                    $this->errorMsg .= $this->errorLang[3] . '<br />
                    ';
                    $this->errorReg = TRUE;
                }
            }
        }
        
        /**
         * easy_form::validateMessage()
         * 
         * Validate message field
         * @return void
         * @since 1.0
         */
        protected function validateMessage()
        {
            if($this->message_value == "")
            {
                if($this->opt['message'])
                {
                    $this->errorReg = TRUE;
                    $this->errorEmpty = TRUE;
                }
                
            }
        }
        
        /**
         * easy_form::_openForm()
         * 
         * Open form area
         * @param string $title
         * @return void
         * @since 1.0
         */
        protected function _openForm($title)
        {
            echo '<form action="' . $this->opt['action'] . '" method="' . $this->opt['method'] . '" id="' . $this->opt['prefix'] . 'contact-form">
            <fieldset class="' . $this->opt['prefix'] . 'fieldset">
                <legend>' . $title . '</legend>
                <p id="' . $this->opt['prefix'] . 'error"></p>
            ';
            
            if(isset($_REQUEST[$this->opt['prefix'] . 'submit']))
            {
                if($this->_have_errors())
                {
                    echo '
                <p id="' . $this->opt['prefix'] . 'error-ss">' . $this->errorMsg . '</p>
                    ';
                }
                elseif($this->login_error)
                {
                    echo '
                <p id="' . $this->opt['prefix'] . 'error-ss">' . $this->errorLang[6] . '</p>
                    ';
                }
                else
                {
                     echo '
                <p id="' . $this->opt['prefix'] . 'success">' . $this->successMsg . '</p>
                    ';
                }
            }
            
        }
        
        /**
         * easy_form::_closeForm()
         * 
         * Close form area
         * @return void
         * @since 1.0
         */
        protected function _closeForm()
        {
            echo '
            </fieldset>
        </form>
        ';
        }
        
        /**
         * easy_form::isRequired()
         * 
         * Add * if required field
         * @param string $name
         * @return void
         * @since 1.0
         */
        protected function isRequired($name)
        {
            if($this->opt[$name])
            {
                return '<span class="ef-required"></span>';
            }
        }
        
        /**
         * easy_form::_label()
         * 
         * Create a field label
         * @param string $text
         * @param string $id
         * @return void
         * @since 1.0
         */
        protected function _label($text = "", $id)
        {
            $for = $this->opt['prefix'] . $id;
            echo '<p class="' . $this->opt['prefix'] . 'p-label">
                        <label for="' . $for . '" class="' . $this->opt['prefix'] . 'label">' . $text . '</label>' . $this->br;
        }
        
        /**
         * easy_form::_name()
         * 
         * Simple text field
         * @return void
         * @since 1.0
         */
        protected function _name()
        {
            echo '
                        <input autocomplete="off" type="text" id="' . $this->opt['prefix'] . 'name" value="'. $this->name_value . '" name="' . $this->opt['prefix'] . 'name" class="' . $this->opt['prefix'] . 'input" />' . $this->isRequired('name') . '
                    </p>
                    ';
        }
        
        /**
         * easy_form::_email()
         * 
         * Email field
         * @return void
         * @since 1.0
         */
        protected function _email()
        {
            $type = "text";
            if($this->opt['html5'])
            {
                $type = "email";
            }
            echo '
                        <input autocomplete="off" type="' . $type . '" id="' . $this->opt['prefix'] . 'email" value="'. $this->email_value . '" name="' . $this->opt['prefix'] . 'email" class="' . $this->opt['prefix'] . 'input" />' . $this->isRequired('email') . '
                    </p>
                    ';
        }
        
        /**
         * easy_form::_password()
         * 
         * Password field
         * @return void
         * @since 1.0
         */
        protected function _password()
        {
            echo '
                        <input autocomplete="off" type="password" id="' . $this->opt['prefix'] . 'password" value="" name="' . $this->opt['prefix'] . 'password" class="' . $this->opt['prefix'] . 'input" />' . $this->isRequired('password') . '
                    </p>
                    ';
                    if($this->opt['password-test'])
                    {
                        echo '<div id="' . $this->opt['prefix'] . 'cont">' . $this->formLang[9] . '
                        <div id="' . $this->opt['prefix'] . 'result">
				<span id="' . $this->opt['prefix'] . 'bar"></span>
			</div>
            </div>';
                    }
        }
        
        /**
         * easy_form::_password2()
         * 
         * repeat password field
         * @return void
         * @since 1.0
         */
        protected function _password2()
        {
            echo '
                        <input autocomplete="off" type="password" id="' . $this->opt['prefix'] . 'password2" value="" name="' . $this->opt['prefix'] . 'password2" class="' . $this->opt['prefix'] . 'input" />' . $this->isRequired('password2') . '
                    </p>
                    ';
        }
        
        /**
         * easy_form::_message()
         * 
         * Free text field
         * @return void
         * @since 1.0
         */
        protected function _message()
        {
            echo '
                        <textarea id="' . $this->opt['prefix'] . 'message" name="' . $this->opt['prefix'] . 'message">' . $this->message_value . '</textarea>' . $this->isRequired('message') . '
                    </p>
                    ';
                    if($this->opt['message-limit'])
                    {
                        echo '<p id="' . $this->opt['prefix'] . 'p-limit">' . $this->formLang[8] . ': <span id="' . $this->opt['prefix'] . 'limit"></span></p>
                        ';
                    }
        }
        
        /**
         * easy_form::_url()
         * 
         * url field
         * @return void
         * @since 1.0
         */
        protected function _url()
        {
            $type = "text";
            if($this->opt['html5'])
            {
                $type = "url";
            }
            echo '
                        <input autocomplete="off" type="' . $type . '" id="' . $this->opt['prefix'] . 'url" value="'. $this->url_value . '" name="' . $this->opt['prefix'] . 'url" class="' . $this->opt['prefix'] . 'input" />' . $this->isRequired('url') . '
                    </p>
                    ';
        }
        
        /**
         * easy_form::_phone()
         * 
         * phone field
         * @return void
         * @since 1.0
         */
        protected function _phone()
        {
            $type = "text";
            if($this->opt['html5'])
            {
                $type = "tel";
            }
            echo '
                        <input autocomplete="off" type="' . $type . '" id="' . $this->opt['prefix'] . 'phone" value="'. $this->phone_value . '" name="' . $this->opt['prefix'] . 'phone" class="' . $this->opt['prefix'] . 'input" />' . $this->isRequired('phone') . '
                    </p>
                    ';
        }
        
        /**
         * easy_form::_submit()
         * 
         * Create submit button
         * @param string $value
         * @return void
         * @since 1.0
         */
        protected function _submit($value)
        {
            echo '<p class="' . $this->opt['prefix'] . 'p-label">
                        <input type="submit" value="' . $value . '" class="' . $this->opt['prefix'] . 'button" id="' . $this->opt['prefix'] . 'submit" name="' . $this->opt['prefix'] . 'submit" />
                    </p>
                    ';
        }
        
        /**
         * easy_form::_loadStyle()
         * 
         * Load css document
         * @param string $url
         * @return void
         * @since 1.0
         */
        public function _loadStyle($url)
        {
            echo '<link href="' . $url . '" rel="stylesheet" type="text/css" />
            ';
        }
        
        /**
         * easy_form::_loadjQuery()
         * 
         * Load jQuery library latest version
         * @return void
         * @since 1.0
         */
        public function _loadjQuery()
        {
            echo '<script src="http://code.jquery.com/jquery-latest.js"></script>
            ';
        }
        
        /**
         * easy_form::_loadScripts()
         * 
         * Load validation scripts and other
         * plugin if required
         * @return void
         * @since 1.0
         */
        public function _loadScripts()
        {
   
            
            
            ?>
            <script type="text/javascript">
                // Load plugin if required
                <?php if($this->opt['message-limit']) { include dirname(__FILE__) . '/js/jquery.maxChars.js';} ?>
                <?php if($this->opt['password-test']) { include dirname(__FILE__) . '/js/jquery.YIWpasswordStrongTester.js'; } ?>
                $(document).ready(function(){
                    // Plugin message limit
                    <?php if($this->opt['message-limit']) { ?>
                    $("#<?php echo $this->opt['prefix']; ?>message").maxChar({
                    	maxCh: <?php echo $this->opt['message-limit']; ?>,
                    	id_result: "<?php echo $this->opt['prefix']; ?>limit",
                    	alertClass: "<?php echo $this->opt['prefix']; ?>alert",
                    	alertClassInit: 10
                    });
                    <?php } ?>
                    // plugin password
                    <?php if($this->opt['password-test']) { ?>
                    $("#<?php echo $this->opt['prefix']; ?>password").YIWpasswordStrongTester({
                    	resultId: "<?php echo $this->opt['prefix']; ?>result",
                    	barId: "<?php echo $this->opt['prefix']; ?>bar"
                    });
                    <?php } ?>
                    
                   var myform = $('form#<?php echo $this->opt['prefix'] . 'contact-form'; ?>');
                   myform.submit(function(){
                        $('#<?php echo $this->opt['prefix']; ?>error').hide();
                         var isEmpty = 0;
                         var emailErr = 0;
                         var urlErr = 0;
                         var stringErr = 0;
                         var passErr = 0;
                         var phoneErr = 0;
                         var errorMessage = "";
                         <?php
                         if($this->opt['ajax'])
                         {
                            ?>
                            var ajaxUrl = '<?php echo $this->opt['ajax']; ?>';
                            <?php
                         }
                         else
                         {
                            ?>
                            var ajaxUrl = false;
                            <?php
                         }
                            ?>
                         
                         if($('#<?php echo $this->opt['prefix'] . 'error-ss';?>').length)
                         {
                            $('#<?php echo $this->opt['prefix'] . 'error-ss';?>').remove();
                         }
                         if($('#<?php echo $this->opt['prefix'] . 'success';?>').length)
                         {
                            $('#<?php echo $this->opt['prefix'] . 'success';?>').remove();
                         }
                         
                         // NAME
                         if($('#<?php echo $this->opt['prefix'] . 'name'; ?>').length)
                         {
                            var n = $('#<?php echo $this->opt['prefix'] . 'name'; ?>');
                            n.removeClass('field-error');
                            if(n.val() == "")
                            {
                                if(<?php echo (int)$this->opt['name']; ?>)
                                {
                                    isEmpty = 1;
                                    n.addClass('field-error');
                                }
                                
                            }
                            else
                            {
                                var expr = <?php echo $this->regExpName; ?>;
                                var Name = n.val();
                                if(!expr.test(Name))
                                {
                                    stringErr = 1;
                                    n.addClass('field-error');
                                }
                            }
                            
                         }
                         
                         // EMAIL
                         if($('#<?php echo $this->opt['prefix'] . 'email'; ?>').length)
                         {
                            var e = $('#<?php echo $this->opt['prefix'] . 'email'; ?>');
                            e.removeClass('field-error');
                            if(e.val() == "")
                            {
                                if(<?php echo (int)$this->opt['email']; ?>)
                                {
                                    isEmpty = 1;
                                    e.addClass('field-error');
                                }
                                
                            }
                            else
                            {
                                var expr = <?php echo $this->regExpEmail; ?>;
                                var email = e.val();
                                if(!expr.test(email))
                                {
                                    emailErr = 1;
                                    e.addClass('field-error');
                                }
                            }
                           
                         }
                         
                         //MESSAGE
                         if($('#<?php echo $this->opt['prefix'] . 'message'; ?>').length)
                         {
                            var m = $('#<?php echo $this->opt['prefix'] . 'message'; ?>');
                            m.removeClass('field-error');
                            if(m.val() == "")
                            {
                                if(<?php echo (int)$this->opt['message']; ?>)
                                {
                                    isEmpty = 1;
                                    m.addClass('field-error');
                                }
                                
                            }
                         }
                         
                         //URL
                         if($('#<?php echo $this->opt['prefix'] . 'url'; ?>').length)
                         {
                            var u = $('#<?php echo $this->opt['prefix'] . 'url'; ?>');
                            u.removeClass('field-error');
                            if(u.val() == "")
                            {
                                if(<?php echo (int)$this->opt['url']; ?>)
                                {
                                    isEmpty = 1;
                                    u.addClass('field-error');
                                }
                                
                            }
                            else
                            {
                                var expr = <?php echo $this->regExpUrl; ?>;
                                var url = u.val();
                                if(!expr.test(url))
                                {
                                    urlErr = 1;
                                    u.addClass('field-error');
                                }
                            }
                            
                         }
                         
                         //PHONE
                         if($('#<?php echo $this->opt['prefix'] . 'phone'; ?>').length)
                         {
                            var p = $('#<?php echo $this->opt['prefix'] . 'phone'; ?>');
                            p.removeClass('field-error');
                            if(p.val() == "")
                            {
                                if(<?php echo (int)$this->opt['phone']; ?>)
                                {
                                    isEmpty = 1;
                                    p.addClass('field-error');
                                }
                                
                            }
                            else
                            {
                                var expr = <?php echo $this->regExpPhone; ?>;
                                var phone = p.val();
                                if(!expr.test(phone))
                                {
                                    phoneErr = 1;
                                    p.addClass('field-error');
                                }
                            }
                            
                         }
                         
                         //PASSWORD
                         if($('#<?php echo $this->opt['prefix'] . 'password'; ?>').length)
                         {
                            var p1 = $('#<?php echo $this->opt['prefix'] . 'password'; ?>');
                            p1.removeClass('field-error');
                            if(p1.val() == "")
                            {
                                isEmpty = 1;
                                p1.addClass('field-error');
                            }
                         }
                         
                         //PASSWORD2
                         if($('#<?php echo $this->opt['prefix'] . 'password2'; ?>').length)
                         {
                            var p2 = $('#<?php echo $this->opt['prefix'] . 'password2'; ?>');
                            p2.removeClass('field-error');
                            if(p2.val() == "")
                            {
                                isEmpty = 1;
                                p2.addClass('field-error');
                            }
                         }
                         
                         //PASSWORD ==
                         if($('#<?php echo $this->opt['prefix'] . 'password'; ?>').length && $('#<?php echo $this->opt['prefix'] . 'password2'; ?>').length)
                         {
                            //p1.removeClass('field-error');
                            //p2.removeClass('field-error');
                            var pass = p1.val();
                            var pass2 = p2.val();
                            if(pass != pass2)
                            {
                                passErr = 1;
                                p1.addClass('field-error');
                                p2.addClass('field-error');
                            }
                         }
                         
                         //PARSE ERROR
                         if(isEmpty == 1)
                         {
                            errorMessage += '<?php echo trim($this->errorLang[0]); ?><br />';
                         }
                         
                         if(emailErr == 1)
                         {
                            errorMessage += '<?php echo trim($this->errorLang[1]); ?><br />';
                         }
                         
                         if(urlErr == 1)
                         {
                            errorMessage += '<?php echo trim($this->errorLang[2]); ?><br />';
                         }
                         
                         if(phoneErr == 1)
                         {
                            errorMessage += '<?php echo trim($this->errorLang[3]); ?><br />';
                         }
                         
                         if(stringErr == 1)
                         {
                            errorMessage += '<?php echo trim($this->errorLang[4]); ?><br />';
                         }
                         
                         if(passErr == 1)
                         {
                            errorMessage += '<?php echo trim($this->errorLang[5]); ?><br />';
                         }
                         
                         if(errorMessage != 0)
                         {
                            $('p#<?php echo $this->opt['prefix']; ?>error').html(errorMessage).slideDown('slow');
                            return false;
                         }
                         else
                         {
                            if(ajaxUrl)
                            {
                                var querystring = myform.serialize();
                                
                                 $.ajax({
                                    url: ajaxUrl,
                                    type: "POST",
                                    data: querystring,
                                    success: function(data) {
                                        <?php require dirname(__FILE__) . '/js/success.js';?>        
                                    }
                                 });
                                return false;
     
                            }
                            
                         }
                         
                                                
                   }); 
                });
            </script>
            <?php
        }
        
        /**
         * easy_form::_simpleRegistrationForm()
         * 
         * Print simple registration form
         * @param string $title
         * @param $string $submit_value
         * @return void
         * @since 1.0
         */
        public function _simpleRegistrationForm($title,$submit_value)
        {
            $this->_openForm($title);
            $this->_label(trim($this->formLang[0]), "name");
            $this->_name();
    
            $this->_label(trim($this->formLang[4]), "email");
            $this->_email();
            
            $this->_label(trim($this->formLang[2]), "password");
            $this->_password();
            
            $this->_label(trim($this->formLang[3]), "password2");
            $this->_password2();
            
            $this->_submit($submit_value);
            $this->_closeForm();
        }
        
        /**
         * easy_form::_simpleContactForm()
         * 
         * Print simple contact form
         * @param string $title
         * @param string $submit_value
         * @return void
         * @since 1.0
         */
        public function _simpleContactForm($title,$submit_value)
        {
            $this->_openForm($title);
            $this->_label(trim($this->formLang[1]), "name");
            $this->_name();
    
            $this->_label(trim($this->formLang[4]), "email");
            $this->_email();
    
            $this->_label(trim($this->formLang[7]), "message");
            $this->_message();
            $this->_submit($submit_value);
            $this->_closeForm();
        }
        
        /**
         * easy_form::_simpleLoginForm()
         * 
         * Print simple login form
         * @param string $title
         * @param string $submit_value
         * @return void
         * @since 1.0
         */
        public function _simpleLoginForm($title,$submit_value)
        {
            $this->_openForm($title);
            $this->_label(trim($this->formLang[0]), "name");
            $this->_name();
            
            $this->_label(trim($this->formLang[2]), "password");
            $this->_password();
            
            $this->_submit($submit_value);
            $this->_closeForm();
        }
        
        /**
         * easy_form::_customForm()
         * 
         * Print custom form
         * @param string $title
         * @param string $submit_value
         * @param array $fields
         * @return void
         * @since 1.0
         */
        public function _customForm($title,$submit_value,$fields)
        {
            $this->_openForm($title);
            foreach($fields as $field => $label)
            {
                $field = trim($field);
                $label = trim($label);
                $this->_label($label,$field);
                call_user_func(array($this, '_' . $field));
            }
            $this->_submit($submit_value);
            $this->_closeForm();
        }
}



?>

