<?php
/**
 * Document: class.ycpager.php
 * Created on: 17-apr-2012, 12:40
 * Author : Nicola Mustone <mustone.nicola@gmail.com>
   		    per Your Inspiration Web [http://www.yourinspirationweb.com]
 * Description: Classe YCPager. Crea una paginazione tramite un database.
 */
class YCPager {
	/**
	 * Pagina attuale.
	 *
	 * @var int
	 * @access private
	 * @since 1.0
	 */
	private $_currentPage = 0;
	
	/**
	 * Il numero totale di righe.
	 *
	 * @var int
	 * @access private
	 * @since 1.0
	 */
	private $_totalRows = 0;
	
	/**
	 * Il numero di pagine precedenti a quella attuale da stampare.
	 *
	 * @var int
	 * @access private
	 * @since 1.0
	 */
	private $_prevLink = 2;
	
	/**
	 * Il numero di pagine successiva a quella attuale da stampare.
	 *
	 * @var int
	 * @access private
	 * @since 1.0
	 */
	private $_nextLink = 2;
	
	/**
	 * Il valore di OFFSET nella query SQL.
	 *
	 * @var int
	 * @access private
	 * @since 1.0
	 */
	private $_queryLimit = 0;
	
	/**
	 * Il numero di righe da stampare in ogni pagina.
	 *
	 * @var int
	 * @access private
	 * @since 1.0
	 */
	private $_numPerPage = 0;
    
    /**
     * I link delle pagine reindirizzeranno qui.
     * 
     * @var string
     * @access private
     * @since 1.0
     **/ 
    private $_redirectTo = '';
	
	/**
	 * YCPager::__construct(). Inizializza le variabili.
	 *
	 * @param int $currentPage
	 * @param int $totalRows
	 * @param int $numPerPage
	 * @since 1.0
	 */
	public function __construct($currentPage, $totalRows, $numPerPage, $redirectTo = 'index.php?') {
		$this->_currentPage = (int) max($currentPage, 1);
		$this->_totalRows = (int) max($totalRows, 1);
			
		$this->_numPerPage = (int) $numPerPage;
        $this->_redirectTo = $redirectTo;
	}
	
	/**
	 * YCPager::getOffset(). Restituisce il numero totale di pagine che verranno create.
	 *
	 * @return int
	 * @since 1.0
	 */
	public function getOffset() {
		return ceil($this->_totalRows/$this->_numPerPage);
	}
	
	/**
	 * YCPager::getQueryOffset(). Restituisce l'offset da usare nella query SQL.
	 *
	 * @return int
	 * @since 1.0
	 */
	public function getQueryOffset() {
        return ($this->_currentPage == 1) ? $this->_queryLimit : ($this->_currentPage - 1) * $this->_numPerPage;
    }
	
	/**
	 * YCPager::getPager(). Stampa la paginazione.
	 *
	 * @return void
	 * @since 1.0
	 */
	public function getPager() {
        $currentPage = $this->_currentPage;
        $prev = $this->_prevLink;
        $next = $this->_nextLink;
        $total = $this->getOffset();

        echo '<div class="pagination">';
        echo '<ul>';

        $this->getFirst();
        $this->getPrev();

        if($total < ($prev + $next + 1)) {
            $prev = 0;
            $next = 0;
            for($i = $total; $i > 0; $i--) {
                $return[$i] = $i;
            }
        } else {
            if($currentPage == $total) {
                if($currentPage - ($prev + $next + 1) >= 0) {
                    for($i = $total; $i > ($total - ($prev + $next + 1)); $i--) {
                        $return[$i] = $i;
                    }
                }
            } else if($currentPage < $total) {
                if($currentPage - $prev > 0) {
                    for($i = $currentPage - $prev; $i <    $currentPage + $next + 1; $i++) {
                        $return[$i] = $i;
                    }
                } else if($currentPage - $prev <= 0) {
                    for($i = 1; $i <= ($prev + $next + 1); $i++) {
                        $return[$i] = $i;
                    }
                }
            }
        }

        if(!empty($return)) { sort($return); }

        for($i = 0; $i < count($return); $i++) {
            if($return[$i] != $this->_currentPage)
                echo '<li class="number-page"><a href="' . $this->_redirectTo . 'p='. $return[$i] .'" title="">'. $return[$i] .'</a></li>';
            else
                echo '<li class="actual-page"><span>'. $return[$i] .'</span></li>';
        }

        $this->getNext();
        $this->getLast();

        echo '</ul>';
        echo '</div>';
        echo '<div class="clearer"></div>';
    }
	
	/**
	 * YCPager::getFirst(). Stampa il link alla prima pagina.
	 *
	 * @return void
	 * @since 1.0
	 */
	public function getFirst() {
        if($this->_currentPage != 1)
            echo '<li class="first-page"><a href="' . $this->_redirectTo . 'p=1" title="Inizio">&#171; Inizio</a></li>';
        else
            echo '<li class="first-page">&#171; Inizio</li>' ;
    }
	
	/**
	 * YCPager::getFirst(). Stampa il link all'ultima pagina.
	 *
	 * @return void
	 * @since 1.0
	 */
	public function getLast() {
        if($this->_currentPage != $this->getOffset())
            echo '<li class="last-page"><a href="' . $this->_redirectTo . 'p='. $this->getOffset() .'" title="Fine">Fine &#187;</a></li>';
        else
            echo '<li class="last-page">Fine &#187;</li>';
    }
	
	/**
	 * YCPager::getFirst(). Stampa il link alla pagina precedente a quella attuale.
	 *
	 * @return string
	 * @since 1.0
	 */
	public function getPrev() {
        if($this->_currentPage - 1 > 0)
            echo '<li class="prev-page"><a href="' . $this->_redirectTo . 'p='. ($this->_currentPage - 1) .'" title="Precedente">&lt; Precedente</a></li>';
        else
            echo '<li class="prev-page">&lt; Precedente</li>';
    }
	
	/**
	 * YCPager::getFirst(). Stampa il link alla pagina successiva a quella attuale.
	 *
	 * @return string
	 * @since 1.0
	 */
	public function getNext() {
        if($this->_currentPage + 1 <= $this->getOffset())
            echo '<li class="next-page"><a href="' . $this->_redirectTo . 'p='. ($this->_currentPage + 1) .'" title="Successiva">Successiva &gt;</a></li>';
        else
            echo '<li class="next-page">Successiva &gt;</li>';
    }
}
?>