<?php

/*
Plugin Name: YIW Nivoslider
Description: Grazie a questo widget potrai utilizzare NivoSlider all'interno del tuo sito in Wordpress.
Version: 1.0
License: GPL 2.0
Author: WPinProgress
*/

add_image_size( 'nivo', 950,400, TRUE ); 

class nivoslider_widget extends WP_Widget
{

public function __construct() 
{
    parent::WP_Widget( "yiw_nivoslider", "YIW Nivoslider", array("description" => "Questo widget visualizzera Nivoslider."));
}

public function form( $instance )
{
    $defaults = array( 
       'theme' => 'default',
       'title' => 'Slideshow',

    );
        
    $instance = wp_parse_args( (array) $instance, $defaults ); 
	$themes = array( "default" , "bar" ,"dark" ,"light" );

?>
        
   <p>

     <label for="<?php echo $this->get_field_id( 'title' ); ?>">
	Inserisci il titolo del widget: 
     </label>
     <input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
			
   </p>  
		
   <p>

     <label for="<?php echo $this->get_field_id( 'number' ); ?>">
        Tema da utilizzare:
     </label>
    
	<select class="widefat" name="<?php echo $this->get_field_name( 'theme' ); ?>" id="<?php echo $this->get_field_id( 'theme' ); ?>">
	<?php
	foreach ($themes as $theme)
		{
			if ($theme == $instance['theme'] ) 
					{ echo "<option value='".$theme."' selected='selected' >".$theme."</option>"; } else
					{ echo "<option value='".$theme."'>".$theme."</option>"; };
		}
	?>
    </select>

   </p> 
        
<?php 

}

public function update( $new_instance, $old_instance ) 
{
  $instance = $old_instance;

  $instance['theme'] = strip_tags( $new_instance['theme'] );
  $instance['title'] = strip_tags( $new_instance['title'] );

  return $instance;

}              


public function widget( $args, $instance )

{
 extract( $args );
		
 echo $before_widget;

 $title = apply_filters( 'widget_title', $instance['title'] );
   if ( $title ) {
     echo $before_title.$title.$after_title;
   }
	$file_dir = WP_PLUGIN_URL."/nivowidget";
    wp_enqueue_style( "nivo-slider", $file_dir."/css/nivo-slider.css", false, "1.0", "all" );
    wp_enqueue_style( "default", $file_dir."/themes/".$instance['theme']."/".$instance['theme'].".css", false, "1.0", "all" );
    wp_enqueue_script( 'nivo.slider', $file_dir.'/js/jquery.nivo.slider.js',array('jquery'),'1.0', true  ); 
	wp_enqueue_script("jquery");
	
?>

<!-- START SLIDER -->

<script type="text/javascript">      
jQuery(document).ready(function($){ $('#slider').nivoSlider(); });          
</script>

<!-- SLIDER BEGINS -->
<section class="theme-<?php echo $instance['theme']; ?> slider-wrapper">
		<!-- NIVOSLIDER BEGINS -->
		<div id="slider" class="nivoSlider">
				<?php
				$query = new WP_Query( array ('post_type' => 'post', 'posts_per_page' => '5' )); 
				while( $query->have_posts() ) : $query->the_post();
				if ( has_post_thumbnail() ) {
	            the_post_thumbnail('nivo',array('title' => '<h4>'.get_the_title().'</h4>' ));
				}   
				endwhile;
				wp_reset_postdata();
		    	?>
		</div>
		<!-- NIVOSLIDER END -->
</section>
<!-- SLIDER END -->
  
<?php
    echo $after_widget;
}
}

function add_nivoslider_widget()
{
	register_widget( 'nivoslider_widget' );
}

add_action( 'widgets_init', 'add_nivoslider_widget' );

?>